/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import java.util.Date;

public class MetaDataTableRow
implements Comparable<MetaDataTableRow> {
    private SchemaVersion schemaVersion;
    private String description;
    private MigrationType migrationType;
    private String script;
    private Integer checksum;
    private Date installedOn;
    private Integer executionTime;
    private MigrationState state;

    public MetaDataTableRow(SchemaVersion schemaVersion, String description, MigrationType migrationType, String script, Integer checksum, Date installedOn, Integer executionTime, MigrationState state) {
        this.schemaVersion = schemaVersion;
        this.description = description;
        this.migrationType = migrationType;
        this.script = script;
        this.checksum = checksum;
        this.installedOn = installedOn;
        this.executionTime = executionTime;
        this.state = state;
    }

    public MetaDataTableRow(Migration migration) {
        this.schemaVersion = migration.getVersion();
        this.description = migration.getDescription();
        this.migrationType = migration.getMigrationType();
        this.script = migration.getScript();
        this.checksum = migration.getChecksum();
    }

    public void update(Integer executionTime, MigrationState state) {
        this.executionTime = executionTime;
        this.state = state;
    }

    public MigrationType getMigrationType() {
        return this.migrationType;
    }

    public Integer getChecksum() {
        return this.checksum;
    }

    public SchemaVersion getVersion() {
        return this.schemaVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public MigrationState getState() {
        return this.state;
    }

    public Date getInstalledOn() {
        return this.installedOn;
    }

    public Integer getExecutionTime() {
        return this.executionTime;
    }

    public String getScript() {
        return this.script;
    }

    public void assertNotFailed() {
        if (MigrationState.FAILED == this.state) {
            throw new IllegalStateException("Migration to version " + this.schemaVersion + " failed! Please restore backups and roll back database and code!");
        }
    }

    @Override
    public int compareTo(MetaDataTableRow o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

