/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.h2;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class H2DbSupport
implements DbSupport {
    private final JdbcTemplate jdbcTemplate;

    public H2DbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/h2/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER()";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getSchemas();
                while (resultSet.next()) {
                    if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                    return resultSet.getString("TABLE_SCHEM");
                }
                return null;
            }
        });
    }

    @Override
    public boolean isSchemaEmpty() {
        List tables = this.jdbcTemplate.queryForList("SHOW TABLES FROM " + this.getCurrentSchema());
        return tables.isEmpty();
    }

    @Override
    public boolean tableExists(final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, H2DbSupport.this.getCurrentSchema(), table.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean columnExists(final String table, final String column) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getColumns(null, H2DbSupport.this.getCurrentSchema(), table.toUpperCase(), column.toUpperCase());
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new SqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript() {
        List tables = this.jdbcTemplate.queryForList("SHOW TABLES FROM " + this.getCurrentSchema());
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int count = 0;
        for (Map table : tables) {
            sqlStatements.add(new SqlStatement(++count, "DROP TABLE " + table.get("TABLE_NAME") + " CASCADE"));
        }
        return new SqlScript(sqlStatements);
    }
}

