/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.java.JavaMigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigrationResolver;
import com.googlecode.flyway.core.validation.ValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MigrationProvider {
    private final String basePackage;
    private final String baseDir;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;
    private final Map<String, String> placeholders;
    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private List<Migration> availableMigrations;

    public MigrationProvider(String basePackage, String baseDir, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix, Map<String, String> placeholders, String placeholderPrefix, String placeholderSuffix) {
        this.basePackage = basePackage;
        this.baseDir = baseDir;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
        this.placeholders = placeholders;
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
    }

    public List<Migration> findAvailableMigrations() throws FlywayException {
        if (this.availableMigrations == null) {
            this.availableMigrations = this.doFindAvailableMigrations();
        }
        return this.availableMigrations;
    }

    private List<Migration> doFindAvailableMigrations() throws FlywayException {
        PlaceholderReplacer placeholderReplacer = new PlaceholderReplacer(this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        migrationResolvers.add(new SqlMigrationResolver(this.baseDir, placeholderReplacer, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix));
        migrationResolvers.add(new JavaMigrationResolver(this.basePackage));
        ArrayList<Migration> allMigrations = new ArrayList<Migration>();
        for (MigrationResolver migrationResolver : migrationResolvers) {
            allMigrations.addAll(migrationResolver.resolveMigrations());
        }
        if (allMigrations.isEmpty()) {
            return allMigrations;
        }
        Collections.sort(allMigrations);
        Collections.reverse(allMigrations);
        for (int i = 0; i < allMigrations.size() - 1; ++i) {
            Migration next;
            Migration current = (Migration)allMigrations.get(i);
            if (current.compareTo(next = (Migration)allMigrations.get(i + 1)) != 0) continue;
            throw new ValidationException("Found more than one migration with version: " + current.getVersion());
        }
        return allMigrations;
    }
}

