/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.h2;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2SqlScript
extends SqlScript {
    public H2SqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    H2SqlScript() {
    }

    @Override
    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        return ";";
    }

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String statement) {
        String[] tokens = StringUtils.tokenizeToStringArray((String)statement, (String)" ;=|(),");
        List<Set<TokenType>> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        boolean insideQuoteStringLiteral = false;
        boolean insideDollarStringLiteral = false;
        for (Set<TokenType> delimitingToken : delimitingTokens) {
            if (!insideDollarStringLiteral && !insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.QUOTE_OPEN)) {
                insideQuoteStringLiteral = true;
                continue;
            }
            if (insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.QUOTE_CLOSE)) {
                insideQuoteStringLiteral = false;
                continue;
            }
            if (!insideDollarStringLiteral && !insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.DOLLAR_OPEN)) {
                insideDollarStringLiteral = true;
                continue;
            }
            if (!insideDollarStringLiteral || !delimitingToken.contains((Object)TokenType.DOLLAR_CLOSE)) continue;
            insideDollarStringLiteral = false;
        }
        return insideQuoteStringLiteral || insideDollarStringLiteral;
    }

    private List<Set<TokenType>> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<Set<TokenType>> delimitingTokens = new ArrayList<Set<TokenType>>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace((String)token, (String)"''", (String)"");
            HashSet<TokenType> tokenTypes = new HashSet<TokenType>();
            if (cleanToken.startsWith("'")) {
                if (cleanToken.length() > 1 && cleanToken.endsWith("'")) continue;
                tokenTypes.add(TokenType.QUOTE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_CLOSE);
            }
            if (cleanToken.startsWith("$$")) {
                if (cleanToken.length() > 2 && cleanToken.endsWith("$$")) continue;
                tokenTypes.add(TokenType.DOLLAR_OPEN);
            }
            if (cleanToken.endsWith("$$")) {
                tokenTypes.add(TokenType.DOLLAR_CLOSE);
            }
            if (tokenTypes.isEmpty()) continue;
            delimitingTokens.add(tokenTypes);
        }
        return delimitingTokens;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        QUOTE_OPEN,
        QUOTE_CLOSE,
        DOLLAR_OPEN,
        DOLLAR_CLOSE;

    }
}

