/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.java;

import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.java.JavaMigration;
import com.googlecode.flyway.core.migration.java.JavaMigrationExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMigrationResolver
implements MigrationResolver {
    private final String basePackage;

    public JavaMigrationResolver(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public Collection<Migration> resolveMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(JavaMigration.class));
        Set components = provider.findCandidateComponents(this.basePackage);
        for (BeanDefinition beanDefinition : components) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), (ClassLoader)classLoader);
            JavaMigration javaMigration = (JavaMigration)BeanUtils.instantiateClass((Class)clazz);
            migrations.add(new JavaMigrationExecutor(javaMigration));
        }
        return migrations;
    }
}

