/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataTableRowDumper {
    private static final Log LOG = LogFactory.getLog(MetaDataTableRowDumper.class);

    private MetaDataTableRowDumper() {
    }

    public static void dumpMigration(MetaDataTableRow metaDataTableRow) {
        ArrayList<MetaDataTableRow> metaDataTableRowList = new ArrayList<MetaDataTableRow>();
        if (metaDataTableRow != null) {
            metaDataTableRowList.add(metaDataTableRow);
        }
        MetaDataTableRowDumper.dumpMigrations(metaDataTableRowList);
    }

    public static void dumpMigrations(List<MetaDataTableRow> metaDataTableRows) {
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
        LOG.info((Object)"| Version     | Description            | Installed on        | State   |");
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
        if (metaDataTableRows.isEmpty()) {
            LOG.info((Object)"| No migrations applied yet                                            |");
        } else {
            for (MetaDataTableRow metaDataTableRow : metaDataTableRows) {
                LOG.info((Object)("| " + StringUtils.trimOrPad(metaDataTableRow.getVersion().toString(), 11) + " | " + StringUtils.trimOrPad(metaDataTableRow.getDescription(), 22) + " | " + StringUtils.trimOrPad(MetaDataTableRowDumper.formatInstalledOnDate(metaDataTableRow.getInstalledOn()), 19) + " | " + StringUtils.trimOrPad(metaDataTableRow.getState().name(), 7) + " |"));
            }
        }
        LOG.info((Object)"+-------------+------------------------+---------------------+---------+");
    }

    private static String formatInstalledOnDate(Date installedOn) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(installedOn);
    }
}

