/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlScript;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(OracleDbSupport.class);

    public OracleDbSupport(Connection connection) {
        super(new OracleJdbcTemplate(connection));
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/oracle/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER";
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT USER FROM dual", new String[0]);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM all_objects WHERE owner = ?", schema);
        return objectCount == 0;
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.hasTables(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.update("select * from " + schema + "." + table + " for update", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new OracleSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        if ("SYSTEM".equals(schema.toUpperCase())) {
            throw new FlywayException("Clean not supported on Oracle for user 'SYSTEM'! You should NEVER add your own objects to the SYSTEM schema!");
        }
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.add("PURGE RECYCLEBIN");
        allDropStatements.addAll(this.generateDropStatementsForSpatialExtensions(schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SEQUENCE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("FUNCTION", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("MATERIALIZED VIEW", "PRESERVE TABLE", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PACKAGE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PROCEDURE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SYNONYM", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("VIEW", "CASCADE CONSTRAINTS", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TABLE", "CASCADE CONSTRAINTS PURGE", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TYPE", "FORCE", schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(lineNumber, dropStatement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatementsForObjectType(String objectType, String extraArguments, String schema) throws SQLException {
        String query = "SELECT object_name FROM all_objects WHERE object_type = ? AND owner = ? AND object_name NOT LIKE 'BIN$%' AND object_name NOT LIKE 'MDRT_%$' AND object_name NOT LIKE 'MDRS_%$' AND object_name NOT LIKE 'MLOG$%' AND object_name NOT LIKE 'RUPD$%' AND object_name NOT LIKE 'DR$%'";
        List<String> objectNames = this.jdbcTemplate.queryForStringList(query, objectType, schema.toUpperCase());
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String objectName : objectNames) {
            dropStatements.add("DROP " + objectType + " " + schema + ".\"" + objectName + "\" " + extraArguments);
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForSpatialExtensions(String schema) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (!this.spatialExtensionsAvailable()) {
            LOG.debug((Object)"Oracle Spatial Extensions are not available. No cleaning of MDSYS tables and views.");
            return statements;
        }
        if (!this.getCurrentSchema().equalsIgnoreCase(schema)) {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM all_sdo_geom_metadata WHERE owner=?", schema.toUpperCase());
            if ((count += this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM all_sdo_index_info WHERE sdo_index_owner=?", schema.toUpperCase())) > 0) {
                LOG.warn((Object)("Unable to clean Oracle Spatial objects for schema '" + schema + "' as they do not belong to the default schema for this connection!"));
            }
            return statements;
        }
        statements.add("DELETE FROM mdsys.user_sdo_geom_metadata");
        List<String> indexNames = this.jdbcTemplate.queryForStringList("select INDEX_NAME from USER_SDO_INDEX_INFO", new String[0]);
        for (String indexName : indexNames) {
            statements.add("DROP INDEX \"" + indexName + "\"");
        }
        return statements;
    }

    private boolean spatialExtensionsAvailable() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM all_views WHERE owner = 'MDSYS' AND view_name = 'USER_SDO_GEOM_METADATA'", new String[0]) > 0;
    }
}

