/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Migration
implements Comparable<Migration> {
    protected SchemaVersion schemaVersion = SchemaVersion.EMPTY;
    protected String description;
    protected String script;
    protected Integer checksum;

    public abstract MigrationType getMigrationType();

    public Integer getChecksum() {
        return this.checksum;
    }

    public SchemaVersion getVersion() {
        return this.schemaVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public int compareTo(Migration o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Migration)) {
            return false;
        }
        Migration migration = (Migration)o;
        if (this.checksum != null ? !this.checksum.equals(migration.checksum) : migration.checksum != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(migration.description) : migration.description != null) {
            return false;
        }
        return !(this.schemaVersion == null ? migration.schemaVersion != null : !this.schemaVersion.equals(migration.schemaVersion)) && !(this.script == null ? migration.script != null : !this.script.equals(migration.script));
    }

    public int hashCode() {
        int result = this.schemaVersion != null ? this.schemaVersion.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
        result = 31 * result + (this.checksum != null ? this.checksum.hashCode() : 0);
        return result;
    }

    public abstract void migrate(JdbcTemplate var1, DbSupport var2) throws SQLException;

    public abstract String getLocation();
}

