/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.jdbc;

import com.googlecode.flyway.core.util.ClassUtils;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverDataSource
implements DataSource {
    private Driver driver;
    private String url;
    private String user;
    private String password;
    private String[] initSqls = new String[0];

    public DriverDataSource() {
    }

    public DriverDataSource(Driver driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public DriverDataSource(String driverClass, String url, String user, String password) throws Exception {
        this.driver = (Driver)ClassUtils.instantiate(driverClass);
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
    }

    public void setDriverClass(String driverClass) throws Exception {
        this.driver = (Driver)ClassUtils.instantiate(driverClass);
    }

    public Driver getDriver() {
        return this.driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String[] getInitSqls() {
        return this.initSqls;
    }

    public void setInitSqls(String ... initSqls) {
        this.initSqls = initSqls;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriver(this.getUser(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriver(username, password);
    }

    protected Connection getConnectionFromDriver(String username, String password) throws SQLException {
        Properties props = new Properties();
        if (username != null) {
            props.setProperty("user", username);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        Connection connection = this.driver.connect(this.url, props);
        for (String initSql : this.initSqls) {
            Statement statement = connection.createStatement();
            statement.execute(initSql);
            statement.close();
        }
        return connection;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        throw new UnsupportedOperationException("setLoginTimeout");
    }

    @Override
    public PrintWriter getLogWriter() {
        throw new UnsupportedOperationException("getLogWriter");
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        throw new UnsupportedOperationException("setLogWriter");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return DataSource.class.equals(iface);
    }
}

