/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.SQLException;

public class SqlStatement {
    private static final Log LOG = LogFactory.getLog(SqlStatement.class);
    private int lineNumber;
    private String sql;

    public SqlStatement(int lineNumber, String sql) {
        this.lineNumber = lineNumber;
        this.sql = sql;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSql() {
        return this.sql;
    }

    public void execute(JdbcTemplate jdbcTemplate) {
        LOG.debug("Executing SQL: " + this.sql);
        try {
            jdbcTemplate.executeStatement(this.sql);
        }
        catch (SQLException e) {
            throw new FlywayException("Error executing statement at line " + this.lineNumber + ": " + this.sql, e);
        }
    }
}

