/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatement;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.oracle.OracleJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlStatementBuilder;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(OracleDbSupport.class);

    public OracleDbSupport(Connection connection) {
        super(new OracleJdbcTemplate(connection));
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/oracle/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER";
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT USER FROM dual", new String[0]);
    }

    @Override
    public void setCurrentSchema(String schema) throws SQLException {
        this.jdbcTemplate.execute("ALTER SESSION SET CURRENT_SCHEMA=" + this.quote(schema), new Object[0]);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM all_objects WHERE owner = ?", schema);
        return objectCount == 0;
    }

    @Override
    public boolean tableExistsNoQuotes(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean columnExists(String schema, String table, String column) throws SQLException {
        return this.jdbcTemplate.columnExists(null, schema, table, column);
    }

    @Override
    public boolean primaryKeyExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.primaryKeyExists(null, schema, table);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.execute("select * from " + this.quote(schema, table) + " for update", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new OracleSqlStatementBuilder();
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        if ("SYSTEM".equals(schema.toUpperCase())) {
            throw new FlywayException("Clean not supported on Oracle for user 'SYSTEM'! You should NEVER add your own objects to the SYSTEM schema!");
        }
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.add("PURGE RECYCLEBIN");
        allDropStatements.addAll(this.generateDropStatementsForSpatialExtensions(schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SEQUENCE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("FUNCTION", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("MATERIALIZED VIEW", "PRESERVE TABLE", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PACKAGE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PROCEDURE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SYNONYM", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TRIGGER", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("VIEW", "CASCADE CONSTRAINTS", schema));
        allDropStatements.addAll(this.generateDropStatementsForTables(schema));
        allDropStatements.addAll(this.generateDropStatementsForXmlTables(schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TYPE", "FORCE", schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(lineNumber, dropStatement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements, (DbSupport)this);
    }

    private List<String> generateDropStatementsForTables(String schema) throws SQLException {
        String query = "SELECT table_name FROM all_tables WHERE owner = ? AND table_name NOT LIKE 'BIN$%' AND table_name NOT LIKE 'MDRT_%$' AND table_name NOT LIKE 'MLOG$%' AND table_name NOT LIKE 'RUPD$%' AND table_name NOT LIKE 'DR$%' AND table_name NOT LIKE 'SYS_IOT_OVER_%' AND nested != 'YES' AND secondary != 'Y'";
        List<String> objectNames = this.jdbcTemplate.queryForStringList(query, schema);
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String objectName : objectNames) {
            dropStatements.add("DROP TABLE " + this.quote(schema, objectName) + " CASCADE CONSTRAINTS PURGE");
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForXmlTables(String schema) throws SQLException {
        String query = "SELECT table_name FROM all_xml_tables WHERE owner = ?";
        List<String> objectNames = this.jdbcTemplate.queryForStringList(query, schema);
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String objectName : objectNames) {
            dropStatements.add("DROP TABLE " + this.quote(schema, objectName) + " PURGE");
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForObjectType(String objectType, String extraArguments, String schema) throws SQLException {
        String query = "SELECT object_name FROM all_objects WHERE object_type = ? AND owner = ? AND object_name NOT LIKE 'MDRS_%$'";
        List<String> objectNames = this.jdbcTemplate.queryForStringList(query, objectType, schema);
        ArrayList<String> dropStatements = new ArrayList<String>();
        for (String objectName : objectNames) {
            dropStatements.add("DROP " + objectType + " " + this.quote(schema, objectName) + " " + extraArguments);
        }
        return dropStatements;
    }

    private List<String> generateDropStatementsForSpatialExtensions(String schema) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        if (!this.spatialExtensionsAvailable()) {
            LOG.debug("Oracle Spatial Extensions are not available. No cleaning of MDSYS tables and views.");
            return statements;
        }
        if (!this.getCurrentSchema().equalsIgnoreCase(schema)) {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM all_sdo_geom_metadata WHERE owner=?", schema);
            if ((count += this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM all_sdo_index_info WHERE sdo_index_owner=?", schema)) > 0) {
                LOG.warn("Unable to clean Oracle Spatial objects for schema '" + schema + "' as they do not belong to the default schema for this connection!");
            }
            return statements;
        }
        statements.add("DELETE FROM mdsys.user_sdo_geom_metadata");
        List<String> indexNames = this.jdbcTemplate.queryForStringList("select INDEX_NAME from USER_SDO_INDEX_INFO", new String[0]);
        for (String indexName : indexNames) {
            statements.add("DROP INDEX \"" + indexName + "\"");
        }
        return statements;
    }

    private boolean spatialExtensionsAvailable() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM all_views WHERE owner = 'MDSYS' AND view_name = 'USER_SDO_GEOM_METADATA'", new String[0]) > 0;
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

