/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.dbsupport.Delimiter;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Delimiter PLSQL_DELIMITER = new Delimiter("/", true);
    private boolean insideQuoteStringLiteral = false;
    private boolean insideQStringLiteral = false;
    private String qCloseToken = "]'";
    private String statementStart = "";

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (line.matches("DECLARE|DECLARE\\s.*") || line.matches("BEGIN|BEGIN\\s.*")) {
            return PLSQL_DELIMITER;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 4) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
        }
        if (this.statementStart.startsWith("CREATE FUNCTION") || this.statementStart.startsWith("CREATE PROCEDURE") || this.statementStart.startsWith("CREATE PACKAGE") || this.statementStart.startsWith("CREATE TYPE") || this.statementStart.startsWith("CREATE OR REPLACE FUNCTION") || this.statementStart.startsWith("CREATE OR REPLACE PROCEDURE") || this.statementStart.startsWith("CREATE OR REPLACE PACKAGE") || this.statementStart.startsWith("CREATE OR REPLACE TYPE")) {
            return PLSQL_DELIMITER;
        }
        return delimiter;
    }

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String line) {
        String filteredStatementForParensQQuotes = StringUtils.replaceAll(line, "q'(", "q'[");
        filteredStatementForParensQQuotes = StringUtils.replaceAll(filteredStatementForParensQQuotes, ")'", "]'");
        String[] tokens = StringUtils.tokenizeToStringArray(filteredStatementForParensQQuotes, " ;=|(),");
        List<Token> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        for (Token delimitingToken : delimitingTokens) {
            boolean moreTokensApplicable = true;
            for (TokenType tokenType : delimitingToken.tokenTypes) {
                if (!moreTokensApplicable) continue;
                if (!this.insideQStringLiteral && !this.insideQuoteStringLiteral && tokenType == TokenType.QUOTE_OPEN) {
                    this.insideQuoteStringLiteral = true;
                    if (!delimitingToken.singleTypeApplicable) continue;
                    moreTokensApplicable = false;
                    continue;
                }
                if (this.insideQuoteStringLiteral && tokenType == TokenType.QUOTE_CLOSE) {
                    this.insideQuoteStringLiteral = false;
                    moreTokensApplicable = false;
                    continue;
                }
                if (!this.insideQStringLiteral && !this.insideQuoteStringLiteral && tokenType == TokenType.Q_OPEN) {
                    this.insideQStringLiteral = true;
                    continue;
                }
                if (!this.insideQStringLiteral || tokenType != TokenType.Q_CLOSE) continue;
                this.insideQStringLiteral = false;
                moreTokensApplicable = false;
            }
        }
        return this.insideQuoteStringLiteral || this.insideQStringLiteral;
    }

    private List<Token> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<Token> delimitingTokens = new ArrayList<Token>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace(token, "''", "");
            ArrayList<TokenType> tokenTypes = new ArrayList<TokenType>();
            if (cleanToken.startsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_CLOSE);
            }
            if (cleanToken.startsWith("q'") && cleanToken.length() >= 3) {
                String qOpenToken = cleanToken.substring(0, 3);
                this.qCloseToken = this.computeQCloseToken(qOpenToken);
                tokenTypes.add(TokenType.Q_OPEN);
            }
            if (cleanToken.endsWith(this.qCloseToken)) {
                tokenTypes.add(TokenType.Q_CLOSE);
            }
            if (tokenTypes.isEmpty()) continue;
            Token parsedToken = new Token();
            parsedToken.tokenTypes = tokenTypes;
            parsedToken.singleTypeApplicable = token.length() == 1;
            delimitingTokens.add(parsedToken);
        }
        return delimitingTokens;
    }

    private String computeQCloseToken(String qOpenToken) {
        char specialChar = qOpenToken.charAt(2);
        switch (specialChar) {
            case '[': {
                return "]'";
            }
            case '(': {
                return ")'";
            }
            case '{': {
                return "}'";
            }
            case '<': {
                return ">'";
            }
        }
        return specialChar + "'";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        QUOTE_OPEN,
        QUOTE_CLOSE,
        Q_OPEN,
        Q_CLOSE;

    }

    private class Token {
        public List<TokenType> tokenTypes;
        public boolean singleTypeApplicable;

        private Token() {
        }
    }
}

