/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.info;

import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.util.DateUtils;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;

public class MigrationInfoDumper {
    private static final Log LOG = LogFactory.getLog(MigrationInfoDumper.class);

    private MigrationInfoDumper() {
    }

    public static void dumpMigrations(MigrationInfo[] migrationInfos) {
        LOG.info("+-------------+------------------------+---------------------+---------+");
        LOG.info("| Version     | Description            | Installed on        | State   |");
        LOG.info("+-------------+------------------------+---------------------+---------+");
        if (migrationInfos.length == 0) {
            LOG.info("| No migrations found                                                  |");
        } else {
            for (MigrationInfo migrationInfo : migrationInfos) {
                LOG.info("| " + StringUtils.trimOrPad(migrationInfo.getVersion().toString(), 11) + " | " + StringUtils.trimOrPad(migrationInfo.getDescription(), 22) + " | " + StringUtils.trimOrPad(DateUtils.formatDateAsIsoString(migrationInfo.getInstalledOn()), 19) + " | " + StringUtils.trimOrPad(migrationInfo.getState().getDisplayName(), 7) + " |");
            }
        }
        LOG.info("+-------------+------------------------+---------------------+---------+");
    }
}

