/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.init;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.metadatatable.AppliedMigration;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;

public class DbInit {
    private static final Log LOG = LogFactory.getLog(DbInit.class);
    private final MetaDataTable metaDataTable;
    private final TransactionTemplate transactionTemplate;

    public DbInit(TransactionTemplate transactionTemplate, MetaDataTable metaDataTable) {
        this.transactionTemplate = transactionTemplate;
        this.metaDataTable = metaDataTable;
    }

    public void init(MigrationVersion initialVersion, String initialDescription) {
        if (this.metaDataTable.getCurrentSchemaVersion() != MigrationVersion.EMPTY) {
            throw new FlywayException("Schema already initialized. Current Version: " + this.metaDataTable.getCurrentSchemaVersion());
        }
        this.metaDataTable.createIfNotExists();
        final AppliedMigration appliedMigration = new AppliedMigration(initialVersion, initialDescription, MigrationType.INIT, initialDescription, null, 0, true);
        this.transactionTemplate.execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                DbInit.this.metaDataTable.insert(appliedMigration);
                return null;
            }
        });
        LOG.info("Schema initialized with version: " + initialVersion);
    }
}

