/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class MetaDataTableTo20FormatUpgrader {
    private static final Log LOG = LogFactory.getLog(MetaDataTableTo20FormatUpgrader.class);
    private final DbSupport dbSupport;
    private final JdbcTemplate jdbcTemplate;
    private final String schema;
    private final String table;
    private final MigrationResolver migrationResolver;

    public MetaDataTableTo20FormatUpgrader(DbSupport dbSupport, String schema, String table, MigrationResolver migrationResolver) {
        this.dbSupport = dbSupport;
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.schema = schema;
        this.table = table;
        this.migrationResolver = migrationResolver;
    }

    public void upgrade() throws FlywayException {
        try {
            if (!this.needsUpgrade()) {
                LOG.debug("No metadata table upgrade to the Flyway 2.0 format necessary");
                return;
            }
            LOG.info("Upgrading the metadata table (" + this.schema + "." + this.table + ") to the Flyway 2.0 format...");
            LOG.info("Checking prerequisites...");
            this.checkPrerequisites();
            LOG.info("Step 1/4: Creating new columns...");
            this.executePart(1);
            LOG.info("Step 2/4: Populating new columns...");
            this.addRanks();
            LOG.info("Step 3/4: Tightening constraints...");
            this.executePart(3);
            LOG.info("Step 4/4: Fixing checksums...");
            this.fixChecksums();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to upgrade the metadata table " + this.dbSupport.quote(this.schema, this.table) + " to the Flyway 2.0 format", e);
        }
    }

    private void fixChecksums() throws SQLException {
        HashMap<MigrationVersion, Integer> correctedChecksums = new HashMap<MigrationVersion, Integer>();
        List<ResolvedMigration> resolvedMigrations = this.migrationResolver.resolveMigrations();
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            if (MigrationType.SQL != resolvedMigration.getType()) continue;
            correctedChecksums.put(resolvedMigration.getVersion(), resolvedMigration.getChecksum());
        }
        for (MigrationVersion version : correctedChecksums.keySet()) {
            this.jdbcTemplate.execute("UPDATE " + this.dbSupport.quote(this.schema) + "." + this.dbSupport.quote(this.table) + " SET " + this.dbSupport.quote("checksum") + " = ?" + " WHERE " + this.dbSupport.quote("version") + " = ?", correctedChecksums.get(version), version.toString());
        }
    }

    private void executePart(int num) {
        ClassPathResource resource = new ClassPathResource(this.dbSupport.getScriptLocation() + "upgradeTo20FormatPart" + num + ".sql");
        String source = resource.loadAsString("UTF-8");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", this.schema);
        placeholders.put("table", this.table);
        String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
        SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
        sqlScript.execute(this.jdbcTemplate);
    }

    private void addRanks() throws SQLException {
        List<String> versions = this.jdbcTemplate.queryForStringList("SELECT " + this.dbSupport.quote("version") + " FROM " + this.dbSupport.quote(this.schema) + "." + this.dbSupport.quote(this.table), new String[0]);
        ArrayList<MigrationVersion> migrationVersions = new ArrayList<MigrationVersion>(versions.size());
        for (String version : versions) {
            migrationVersions.add(new MigrationVersion(version));
        }
        Collections.sort(migrationVersions);
        for (int i = 0; i < migrationVersions.size(); ++i) {
            int rank = i + 1;
            String version = ((MigrationVersion)migrationVersions.get(i)).toString();
            this.jdbcTemplate.execute("UPDATE " + this.dbSupport.quote(this.schema) + "." + this.dbSupport.quote(this.table) + " SET " + this.dbSupport.quote("version_rank") + " = ?, " + this.dbSupport.quote("installed_rank") + " = ? WHERE " + this.dbSupport.quote("version") + " = ?", rank, rank, version);
        }
    }

    private void checkPrerequisites() throws SQLException {
        List<String> versions = this.jdbcTemplate.queryForStringList("select version from " + this.schema + "." + this.table + " where description is null", new String[0]);
        if (!versions.isEmpty()) {
            throw new FlywayException("Unable to upgrade metadata to the new Flyway 2.0 format as description is now mandatory and these migrations do not have one: " + StringUtils.collectionToCommaDelimitedString(versions));
        }
    }

    private boolean needsUpgrade() throws SQLException {
        if (!this.dbSupport.tableExistsNoQuotes(this.schema, this.table)) {
            return false;
        }
        return !this.dbSupport.columnExists(this.schema, this.table, "version_rank");
    }
}

