/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.sql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.resolver.MigrationExecutor;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.PlaceholderReplacer;

public class SqlMigrationExecutor
implements MigrationExecutor {
    private final PlaceholderReplacer placeholderReplacer;
    private final ClassPathResource sqlScriptResource;
    private final String encoding;

    public SqlMigrationExecutor(ClassPathResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding) {
        this.sqlScriptResource = sqlScriptResource;
        this.encoding = encoding;
        this.placeholderReplacer = placeholderReplacer;
    }

    public void execute(JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        String sqlScriptSource = this.sqlScriptResource.loadAsString(this.encoding);
        String sqlScriptSourceNoPlaceholders = this.placeholderReplacer.replacePlaceholders(sqlScriptSource);
        SqlScript sqlScript = new SqlScript(sqlScriptSourceNoPlaceholders, dbSupport);
        sqlScript.execute(jdbcTemplate);
    }
}

