/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.common.configuration.model;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class InvocationTimePublishRequest {
    public static final String PROP_KEY_SCAN = "scan";
    private static final List<String> PUBLISHING_VALUES = ImmutableList.of("", "true", "yes");
    private static final List<String> NO_PUBLISHING_VALUES = ImmutableList.of("false", "no");
    private final String value;

    InvocationTimePublishRequest(String string) {
        this.value = string;
    }

    public boolean shouldPublish() {
        return PUBLISHING_VALUES.contains(this.value);
    }

    public Optional<String> getIllegalValueErrorMessage() {
        if (this.hasIllegalValue()) {
            return Optional.of("Illegal value for the 'scan' system property. Actual value was '" + this.value + "'. Allowed valued are ['true', 'yes', no value] to publish, ['false', 'no'] to prevent publishing.");
        }
        return Optional.empty();
    }

    private boolean hasIllegalValue() {
        return !this.shouldPublish() && !NO_PUBLISHING_VALUES.contains(this.value);
    }
}

