/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.DFAState;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dtd.StructValidator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.PrefixedName;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.StringUtil;
import java.util.TreeSet;

public final class DFAValidator
extends StructValidator {
    DFAState mState;

    public DFAValidator(DFAState dFAState) {
        this.mState = dFAState;
    }

    @Override
    public StructValidator newInstance() {
        return new DFAValidator(this.mState);
    }

    @Override
    public String tryToValidate(PrefixedName prefixedName) {
        DFAState dFAState = this.mState.findNext(prefixedName);
        if (dFAState == null) {
            TreeSet<PrefixedName> treeSet = this.mState.getNextNames();
            if (treeSet.size() == 0) {
                return "Expected $END";
            }
            if (this.mState.isAcceptingState()) {
                return "Expected <" + StringUtil.concatEntries(treeSet, ">, <", null) + "> or $END";
            }
            return "Expected <" + StringUtil.concatEntries(treeSet, ">, <", "> or <") + ">";
        }
        this.mState = dFAState;
        return null;
    }

    @Override
    public String fullyValid() {
        if (this.mState.isAcceptingState()) {
            return null;
        }
        TreeSet<PrefixedName> treeSet = this.mState.getNextNames();
        return "Expected <" + StringUtil.concatEntries(treeSet, ">, <", "> or <") + ">";
    }
}

