/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.AsciiReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.CharsetNames;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.ISOLatinReader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.InputSourceFactory;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.ReaderBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.StreamBootstrapper;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.SystemId;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.UTF32Reader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.UTF8Reader;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.WstxInputSource;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public final class DefaultInputResolver {
    private DefaultInputResolver() {
    }

    public static WstxInputSource resolveEntity(WstxInputSource wstxInputSource, URL uRL, String string, String string2, String string3, XMLResolver xMLResolver, ReaderConfig readerConfig, int n2) throws IOException, XMLStreamException {
        Object object;
        if (uRL == null && (uRL = wstxInputSource.getSource()) == null) {
            uRL = URLUtil.urlFromCurrentDir();
        }
        if (xMLResolver != null && (object = xMLResolver.resolveEntity(string2, string3, uRL.toExternalForm(), string)) != null) {
            return DefaultInputResolver.sourceFrom(wstxInputSource, readerConfig, string, n2, object);
        }
        if (string3 == null) {
            throw new XMLStreamException("Can not resolve " + (string == null ? "[External DTD subset]" : "entity '" + string + "'") + " without a system id (public id '" + string2 + "')");
        }
        object = URLUtil.urlFromSystemId(string3, uRL);
        return DefaultInputResolver.sourceFromURL(wstxInputSource, readerConfig, string, n2, (URL)object, string2);
    }

    public static WstxInputSource resolveEntityUsing(WstxInputSource wstxInputSource, String string, String string2, String string3, XMLResolver xMLResolver, ReaderConfig readerConfig, int n2) throws IOException, XMLStreamException {
        Object object;
        URL uRL;
        URL uRL2 = uRL = wstxInputSource == null ? null : wstxInputSource.getSource();
        if (uRL == null) {
            uRL = URLUtil.urlFromCurrentDir();
        }
        return (object = xMLResolver.resolveEntity(string2, string3, uRL.toExternalForm(), string)) == null ? null : DefaultInputResolver.sourceFrom(wstxInputSource, readerConfig, string, n2, object);
    }

    protected static WstxInputSource sourceFrom(WstxInputSource wstxInputSource, ReaderConfig readerConfig, String string, int n2, Object object) throws IllegalArgumentException, IOException, XMLStreamException {
        if (object instanceof Source) {
            if (object instanceof StreamSource) {
                return DefaultInputResolver.sourceFromSS(wstxInputSource, readerConfig, string, n2, (StreamSource)object);
            }
            throw new IllegalArgumentException("Can not use other Source objects than StreamSource: got " + object.getClass());
        }
        if (object instanceof URL) {
            return DefaultInputResolver.sourceFromURL(wstxInputSource, readerConfig, string, n2, (URL)object, null);
        }
        if (object instanceof InputStream) {
            return DefaultInputResolver.sourceFromIS(wstxInputSource, readerConfig, string, n2, (InputStream)object, null, null);
        }
        if (object instanceof Reader) {
            return DefaultInputResolver.sourceFromR(wstxInputSource, readerConfig, string, n2, (Reader)object, null, null);
        }
        if (object instanceof String) {
            return DefaultInputResolver.sourceFromString(wstxInputSource, readerConfig, string, n2, (String)object);
        }
        if (object instanceof File) {
            URL uRL = URLUtil.toURL((File)object);
            return DefaultInputResolver.sourceFromURL(wstxInputSource, readerConfig, string, n2, uRL, null);
        }
        throw new IllegalArgumentException("Unrecognized input argument type for sourceFrom(): " + object.getClass());
    }

    public static Reader constructOptimizedReader(ReaderConfig readerConfig, InputStream inputStream, boolean bl2, String string) throws XMLStreamException {
        BaseReader baseReader;
        int n2 = readerConfig.getInputBufferLength();
        String string2 = CharsetNames.normalize(string);
        boolean bl3 = true;
        if (string2 == "UTF-8") {
            baseReader = new UTF8Reader(readerConfig, inputStream, readerConfig.allocFullBBuffer(n2), 0, 0, bl3);
        } else if (string2 == "ISO-8859-1") {
            baseReader = new ISOLatinReader(readerConfig, inputStream, readerConfig.allocFullBBuffer(n2), 0, 0, bl3);
        } else if (string2 == "US-ASCII") {
            baseReader = new AsciiReader(readerConfig, inputStream, readerConfig.allocFullBBuffer(n2), 0, 0, bl3);
        } else if (string2.startsWith("UTF-32")) {
            boolean bl4 = string2 == "UTF-32BE";
            baseReader = new UTF32Reader(readerConfig, inputStream, readerConfig.allocFullBBuffer(n2), 0, 0, bl3, bl4);
        } else {
            try {
                return new InputStreamReader(inputStream, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLStreamException("[unsupported encoding]: " + unsupportedEncodingException);
            }
        }
        if (bl2) {
            baseReader.setXmlCompliancy(272);
        }
        return baseReader;
    }

    private static WstxInputSource sourceFromSS(WstxInputSource wstxInputSource, ReaderConfig readerConfig, String string, int n2, StreamSource streamSource) throws IOException, XMLStreamException {
        InputBootstrapper inputBootstrapper;
        Closeable closeable;
        Reader reader = streamSource.getReader();
        String string2 = streamSource.getPublicId();
        String string3 = streamSource.getSystemId();
        URL uRL = wstxInputSource == null ? null : wstxInputSource.getSource();
        URL uRL2 = string3 == null || string3.length() == 0 ? null : URLUtil.urlFromSystemId(string3, uRL);
        SystemId systemId = SystemId.construct(string3, uRL2 == null ? uRL : uRL2);
        if (reader == null) {
            closeable = streamSource.getInputStream();
            if (closeable == null) {
                if (uRL2 == null) {
                    throw new IllegalArgumentException("Can not create Stax reader for a StreamSource -- neither reader, input stream nor system id was set.");
                }
                closeable = URLUtil.inputStreamFromURL(uRL2);
            }
            inputBootstrapper = StreamBootstrapper.getInstance(string2, systemId, closeable);
        } else {
            inputBootstrapper = ReaderBootstrapper.getInstance(string2, systemId, reader, null);
        }
        closeable = ((InputBootstrapper)inputBootstrapper).bootstrapInput(readerConfig, false, n2);
        return InputSourceFactory.constructEntitySource(readerConfig, wstxInputSource, string, inputBootstrapper, string2, systemId, n2, (Reader)closeable);
    }

    private static WstxInputSource sourceFromURL(WstxInputSource wstxInputSource, ReaderConfig readerConfig, String string, int n2, URL uRL, String string2) throws IOException, XMLStreamException {
        InputStream inputStream = URLUtil.inputStreamFromURL(uRL);
        SystemId systemId = SystemId.construct(uRL);
        StreamBootstrapper streamBootstrapper = StreamBootstrapper.getInstance(string2, systemId, inputStream);
        Reader reader = streamBootstrapper.bootstrapInput(readerConfig, false, n2);
        return InputSourceFactory.constructEntitySource(readerConfig, wstxInputSource, string, streamBootstrapper, string2, systemId, n2, reader);
    }

    public static WstxInputSource sourceFromString(WstxInputSource wstxInputSource, ReaderConfig readerConfig, String string, int n2, String string2) throws IOException, XMLStreamException {
        return DefaultInputResolver.sourceFromR(wstxInputSource, readerConfig, string, n2, new StringReader(string2), null, string);
    }

    private static WstxInputSource sourceFromIS(WstxInputSource wstxInputSource, ReaderConfig readerConfig, String string, int n2, InputStream inputStream, String string2, String string3) throws IOException, XMLStreamException {
        StreamBootstrapper streamBootstrapper = StreamBootstrapper.getInstance(string2, SystemId.construct(string3), inputStream);
        Reader reader = streamBootstrapper.bootstrapInput(readerConfig, false, n2);
        URL uRL = wstxInputSource.getSource();
        if (string3 != null && string3.length() > 0) {
            uRL = URLUtil.urlFromSystemId(string3, uRL);
        }
        return InputSourceFactory.constructEntitySource(readerConfig, wstxInputSource, string, streamBootstrapper, string2, SystemId.construct(string3, uRL), n2, reader);
    }

    private static WstxInputSource sourceFromR(WstxInputSource wstxInputSource, ReaderConfig readerConfig, String string, int n2, Reader reader, String string2, String string3) throws IOException, XMLStreamException {
        URL uRL;
        ReaderBootstrapper readerBootstrapper = ReaderBootstrapper.getInstance(string2, SystemId.construct(string3), reader, null);
        Reader reader2 = readerBootstrapper.bootstrapInput(readerConfig, false, n2);
        URL uRL2 = uRL = wstxInputSource == null ? null : wstxInputSource.getSource();
        if (string3 != null && string3.length() > 0) {
            uRL = URLUtil.urlFromSystemId(string3, uRL);
        }
        return InputSourceFactory.constructEntitySource(readerConfig, wstxInputSource, string, readerBootstrapper, string2, SystemId.construct(string3, uRL), n2, reader2);
    }
}

