/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitorExpression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.ElementToken;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.OptimizationTag;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.Token;

public class ResidualCalculator
implements ExpressionVisitorExpression {
    protected Token token;
    protected final ExpressionPool pool;

    public ResidualCalculator(ExpressionPool expressionPool) {
        this.pool = expressionPool;
    }

    final Expression calcResidual(Expression expression, ElementToken elementToken) {
        if (elementToken.acceptedPatterns != null && elementToken.acceptedPatterns.length == 1) {
            Expression expression2;
            OptimizationTag optimizationTag;
            if (expression.verifierTag == null) {
                optimizationTag = new OptimizationTag();
                expression.verifierTag = optimizationTag;
            } else {
                optimizationTag = (OptimizationTag)expression.verifierTag;
                expression2 = (Expression)optimizationTag.simpleElementTokenResidual.get(elementToken.acceptedPatterns[0]);
                if (expression2 != null) {
                    return expression2;
                }
            }
            this.token = elementToken;
            expression2 = expression.visit(this);
            optimizationTag.simpleElementTokenResidual.put(elementToken.acceptedPatterns[0], expression2);
            return expression2;
        }
        this.token = elementToken;
        return expression.visit(this);
    }

    public final Expression calcResidual(Expression expression, Token token) {
        if (token instanceof ElementToken) {
            return this.calcResidual(expression, (ElementToken)token);
        }
        Token token2 = this.token;
        this.token = token;
        Expression expression2 = expression.visit(this);
        if (token.isIgnorable()) {
            expression2 = this.pool.createChoice(expression2, expression);
        }
        this.token = token2;
        return expression2;
    }

    @Override
    public Expression onAttribute(AttributeExp attributeExp) {
        if (this.token.match(attributeExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    @Override
    public Expression onChoice(ChoiceExp choiceExp) {
        return this.pool.createChoice(choiceExp.exp1.visit(this), choiceExp.exp2.visit(this));
    }

    @Override
    public Expression onElement(ElementExp elementExp) {
        if (this.token.match(elementExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    @Override
    public Expression onOneOrMore(OneOrMoreExp oneOrMoreExp) {
        return this.pool.createSequence(oneOrMoreExp.exp.visit(this), this.pool.createZeroOrMore(oneOrMoreExp.exp));
    }

    @Override
    public Expression onMixed(MixedExp mixedExp) {
        if (this.token.matchAnyString()) {
            return mixedExp;
        }
        return this.pool.createMixed(mixedExp.exp.visit(this));
    }

    @Override
    public Expression onEpsilon() {
        return Expression.nullSet;
    }

    @Override
    public Expression onNullSet() {
        return Expression.nullSet;
    }

    @Override
    public Expression onAnyString() {
        if (this.token.matchAnyString()) {
            return Expression.anyString;
        }
        return Expression.nullSet;
    }

    @Override
    public Expression onRef(ReferenceExp referenceExp) {
        return referenceExp.exp.visit(this);
    }

    @Override
    public Expression onOther(OtherExp otherExp) {
        return otherExp.exp.visit(this);
    }

    @Override
    public Expression onSequence(SequenceExp sequenceExp) {
        Expression expression = this.pool.createSequence(sequenceExp.exp1.visit(this), sequenceExp.exp2);
        if (sequenceExp.exp1.isEpsilonReducible()) {
            return this.pool.createChoice(expression, sequenceExp.exp2.visit(this));
        }
        return expression;
    }

    @Override
    public Expression onData(DataExp dataExp) {
        if (this.token.match(dataExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    @Override
    public Expression onValue(ValueExp valueExp) {
        if (this.token.match(valueExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    @Override
    public Expression onList(ListExp listExp) {
        if (this.token.match(listExp)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    @Override
    public Expression onConcur(ConcurExp concurExp) {
        return this.pool.createConcur(concurExp.exp1.visit(this), concurExp.exp2.visit(this));
    }

    @Override
    public Expression onInterleave(InterleaveExp interleaveExp) {
        return this.pool.createChoice(this.pool.createInterleave(interleaveExp.exp1.visit(this), interleaveExp.exp2), this.pool.createInterleave(interleaveExp.exp1, interleaveExp.exp2.visit(this)));
    }
}

