/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.util.VersionUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.cfg.JsonNodeFeature;
import java.io.Serializable;

public class DatatypeFeatures
implements Serializable {
    private final int _enabledFor1;
    private final int _enabledFor2;
    private final int _explicitFor1;
    private final int _explicitFor2;

    protected DatatypeFeatures(int n2, int n3, int n4, int n5) {
        this._enabledFor1 = n2;
        this._explicitFor1 = n3;
        this._enabledFor2 = n4;
        this._explicitFor2 = n5;
    }

    public static DatatypeFeatures defaultFeatures() {
        return DefaultHolder.getDefault();
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                return datatypeFeature.enabledIn(this._enabledFor1);
            }
            case 1: {
                return datatypeFeature.enabledIn(this._enabledFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    public boolean isExplicitlySet(DatatypeFeature datatypeFeature) {
        switch (datatypeFeature.featureIndex()) {
            case 0: {
                return datatypeFeature.enabledIn(this._explicitFor1);
            }
            case 1: {
                return datatypeFeature.enabledIn(this._explicitFor2);
            }
        }
        VersionUtil.throwInternal();
        return false;
    }

    private static class DefaultHolder {
        private static final DatatypeFeatures DEFAULT_FEATURES = new DatatypeFeatures(DefaultHolder.collectDefaults((Enum[])EnumFeature.values()), 0, DefaultHolder.collectDefaults((Enum[])JsonNodeFeature.values()), 0);

        private static <F extends Enum<F>> int collectDefaults(F[] FArray) {
            int n2 = 0;
            for (F f2 : FArray) {
                if (!f2.enabledByDefault()) continue;
                n2 |= f2.getMask();
            }
            return n2;
        }

        public static DatatypeFeatures getDefault() {
            return DEFAULT_FEATURES;
        }
    }
}

