/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.ser;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationConfig;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ObjectNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.TokenBuffer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup xmlRootNameLookup) {
        this._rootNameLookup = xmlRootNameLookup;
    }

    public XmlSerializerProvider(XmlSerializerProvider xmlSerializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(xmlSerializerProvider, serializationConfig, serializerFactory);
        this._rootNameLookup = xmlSerializerProvider._rootNameLookup;
    }

    @Override
    public DefaultSerializerProvider createInstance(SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        return new XmlSerializerProvider(this, serializationConfig, serializerFactory);
    }

    @Override
    public void serializeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        Object object2;
        boolean bl2;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        Class<?> clazz = object.getClass();
        ToXmlGenerator toXmlGenerator = this._asXmlGenerator(jsonGenerator);
        if (toXmlGenerator == null) {
            bl2 = false;
        } else {
            if (this._shouldUnwrapObjectNode(toXmlGenerator, object)) {
                this._serializeUnwrappedObjectNode(toXmlGenerator, object, null);
                return;
            }
            object2 = this._rootNameFromConfig();
            if (object2 == null) {
                object2 = this._rootNameLookup.findRootName(clazz, this._config);
            }
            this._initWithRootName(toXmlGenerator, (QName)object2);
            bl2 = TypeUtil.isIndexedType(this._config.constructType(clazz));
            if (bl2) {
                this._startRootArray(toXmlGenerator, (QName)object2);
            }
        }
        object2 = this.findTypedValueSerializer(clazz, true, null);
        try {
            ((JsonSerializer)object2).serialize(object, jsonGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    @Override
    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) throws IOException {
        this.serializeValue(jsonGenerator, object, javaType, null);
    }

    @Override
    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) throws IOException {
        boolean bl2;
        ToXmlGenerator toXmlGenerator;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if ((toXmlGenerator = this._asXmlGenerator(jsonGenerator)) == null) {
            bl2 = false;
        } else {
            if (this._shouldUnwrapObjectNode(toXmlGenerator, object)) {
                this._serializeUnwrappedObjectNode(toXmlGenerator, object, jsonSerializer);
                return;
            }
            QName qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = javaType == null ? this._rootNameLookup.findRootName(object.getClass(), this._config) : this._rootNameLookup.findRootName(javaType, this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            boolean bl3 = bl2 = javaType == null ? TypeUtil.isIndexedType(this._config.constructType(object.getClass())) : TypeUtil.isIndexedType(javaType);
            if (bl2) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        }
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    @Override
    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) throws IOException {
        boolean bl2;
        ToXmlGenerator toXmlGenerator;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeXmlNull(jsonGenerator);
            return;
        }
        if (javaType != null && !javaType.getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if ((toXmlGenerator = this._asXmlGenerator(jsonGenerator)) == null) {
            bl2 = false;
        } else {
            QName qName = this._rootNameFromConfig();
            if (qName == null) {
                qName = javaType == null ? this._rootNameLookup.findRootName(object.getClass(), this._config) : this._rootNameLookup.findRootName(javaType, this._config);
            }
            this._initWithRootName(toXmlGenerator, qName);
            boolean bl3 = bl2 = javaType == null ? TypeUtil.isIndexedType(this._config.constructType(object.getClass())) : TypeUtil.isIndexedType(javaType);
            if (bl2) {
                this._startRootArray(toXmlGenerator, qName);
            }
        }
        if (jsonSerializer == null) {
            jsonSerializer = javaType != null && javaType.isContainerType() ? this.findValueSerializer(javaType, null) : this.findValueSerializer(object.getClass(), null);
        }
        try {
            jsonSerializer.serializeWithType(object, jsonGenerator, this, typeSerializer);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
        if (bl2) {
            jsonGenerator.writeEndObject();
        }
    }

    protected void _serializeXmlNull(JsonGenerator jsonGenerator) throws IOException {
        QName qName = this._rootNameFromConfig();
        if (qName == null) {
            qName = XmlRootNameLookup.ROOT_NAME_FOR_NULL;
        }
        if (jsonGenerator instanceof ToXmlGenerator) {
            this._initWithRootName((ToXmlGenerator)jsonGenerator, qName);
        }
        super.serializeValue(jsonGenerator, null);
    }

    protected void _startRootArray(ToXmlGenerator toXmlGenerator, QName qName) throws IOException {
        toXmlGenerator.writeStartObject();
        toXmlGenerator.writeFieldName("item");
    }

    protected void _initWithRootName(ToXmlGenerator toXmlGenerator, QName qName) throws IOException {
        if (!toXmlGenerator.setNextNameIfMissing(qName) && toXmlGenerator.inRoot()) {
            toXmlGenerator.setNextName(qName);
        }
        toXmlGenerator.initGenerator();
        String string = qName.getNamespaceURI();
        if (string != null && string.length() > 0) {
            try {
                toXmlGenerator.getStaxWriter().setDefaultNamespace(string);
            }
            catch (XMLStreamException xMLStreamException) {
                StaxUtil.throwAsGenerationException(xMLStreamException, toXmlGenerator);
            }
        }
    }

    protected QName _rootNameFromConfig() {
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            return null;
        }
        String string = propertyName.getNamespace();
        if (string == null || string.isEmpty()) {
            return new QName(propertyName.getSimpleName());
        }
        return new QName(string, propertyName.getSimpleName());
    }

    protected boolean _shouldUnwrapObjectNode(ToXmlGenerator toXmlGenerator, Object object) {
        return toXmlGenerator.isEnabled(ToXmlGenerator.Feature.UNWRAP_ROOT_OBJECT_NODE) && object instanceof ObjectNode && ((ObjectNode)object).size() == 1;
    }

    protected void _serializeUnwrappedObjectNode(ToXmlGenerator toXmlGenerator, Object object, JsonSerializer<Object> jsonSerializer) throws IOException {
        ObjectNode objectNode = (ObjectNode)object;
        Map.Entry<String, JsonNode> entry = objectNode.fields().next();
        JsonNode jsonNode = entry.getValue();
        this._initWithRootName(toXmlGenerator, new QName(entry.getKey()));
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(jsonNode.getClass(), true, null);
        }
        try {
            jsonSerializer.serialize(jsonNode, toXmlGenerator, this);
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(toXmlGenerator, exception);
        }
    }

    protected ToXmlGenerator _asXmlGenerator(JsonGenerator jsonGenerator) throws JsonMappingException {
        if (!(jsonGenerator instanceof ToXmlGenerator)) {
            if (jsonGenerator instanceof TokenBuffer) {
                return null;
            }
            throw JsonMappingException.from(jsonGenerator, "XmlMapper does not work with generators of type other than `ToXmlGenerator`; got: `" + jsonGenerator.getClass().getName() + "`");
        }
        return (ToXmlGenerator)jsonGenerator;
    }

    protected IOException _wrapAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        String string = exception.getMessage();
        if (string == null) {
            string = "[no message for " + exception.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)exception);
    }
}

