/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectCollectors;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectSpliterators;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableAsList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableCollection;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMapEntrySet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Ordering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.RegularImmutableSortedSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

public final class ImmutableSortedMap<K, V>
extends ImmutableMap<K, V>
implements NavigableMap<K, V> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap<Comparable, Object> NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet(Ordering.natural()), ImmutableList.of());
    private final transient RegularImmutableSortedSet<K> keySet;
    private final transient ImmutableList<V> valueList;
    private transient ImmutableSortedMap<K, V> descendingMap;

    public static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> function, Function<? super T, ? extends V> function2) {
        return CollectCollectors.toImmutableSortedMap(comparator, function, function2);
    }

    static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator), ImmutableList.of());
    }

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    private static <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K k2, V v2) {
        return new ImmutableSortedMap<K, V>(new RegularImmutableSortedSet<K>(ImmutableList.of(k2), Preconditions.checkNotNull(comparator)), ImmutableList.of(v2));
    }

    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Ordering ordering = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOfInternal(map, ordering);
    }

    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        SortedMap sortedMap;
        boolean bl2 = false;
        if (map instanceof SortedMap) {
            sortedMap = (SortedMap)map;
            Comparator comparator2 = sortedMap.comparator();
            boolean bl3 = comparator2 == null ? comparator == NATURAL_ORDER : (bl2 = comparator.equals(comparator2));
        }
        if (bl2 && map instanceof ImmutableSortedMap && !((ImmutableSortedMap)(sortedMap = (ImmutableSortedMap)map)).isPartialView()) {
            return sortedMap;
        }
        return ImmutableSortedMap.fromEntries(comparator, bl2, map.entrySet());
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean bl2, Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
        Map.Entry[] entryArray = Iterables.toArray(iterable, EMPTY_ENTRY_ARRAY);
        return ImmutableSortedMap.fromEntries(comparator, bl2, entryArray, entryArray.length);
    }

    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean bl2, Map.Entry<K, V>[] entryArray, int n2) {
        switch (n2) {
            case 0: {
                return ImmutableSortedMap.emptyMap(comparator);
            }
            case 1: {
                Map.Entry<K, V> entry3 = Objects.requireNonNull(entryArray[0]);
                return ImmutableSortedMap.of(comparator, entry3.getKey(), entry3.getValue());
            }
        }
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n2];
        if (bl2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Map.Entry<K, V> entry4 = Objects.requireNonNull(entryArray[i2]);
                K k2 = entry4.getKey();
                V v2 = entry4.getValue();
                CollectPreconditions.checkEntryNotNull(k2, v2);
                objectArray[i2] = k2;
                objectArray2[i2] = v2;
            }
        } else {
            Arrays.sort(entryArray, 0, n2, (entry, entry2) -> {
                Objects.requireNonNull(entry);
                Objects.requireNonNull(entry2);
                return comparator.compare(entry.getKey(), entry2.getKey());
            });
            Map.Entry<K, V> entry5 = Objects.requireNonNull(entryArray[0]);
            K k3 = entry5.getKey();
            objectArray[0] = k3;
            objectArray2[0] = entry5.getValue();
            CollectPreconditions.checkEntryNotNull(objectArray[0], objectArray2[0]);
            for (int i3 = 1; i3 < n2; ++i3) {
                Map.Entry<K, V> entry6 = Objects.requireNonNull(entryArray[i3 - 1]);
                Map.Entry<K, V> entry7 = Objects.requireNonNull(entryArray[i3]);
                K k4 = entry7.getKey();
                V v3 = entry7.getValue();
                CollectPreconditions.checkEntryNotNull(k4, v3);
                objectArray[i3] = k4;
                objectArray2[i3] = v3;
                ImmutableSortedMap.checkNoConflict(comparator.compare(k3, k4) != 0, "key", entry6, entry7);
                k3 = k4;
            }
        }
        return new ImmutableSortedMap(new RegularImmutableSortedSet<K>(new RegularImmutableList(objectArray), comparator), new RegularImmutableList(objectArray2));
    }

    public static <K extends Comparable<?>, V> Builder<K, V> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        return new Builder(comparator);
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> regularImmutableSortedSet, ImmutableList<V> immutableList) {
        this(regularImmutableSortedSet, immutableList, null);
    }

    ImmutableSortedMap(RegularImmutableSortedSet<K> regularImmutableSortedSet, ImmutableList<V> immutableList, ImmutableSortedMap<K, V> immutableSortedMap) {
        this.keySet = regularImmutableSortedSet;
        this.valueList = immutableList;
        this.descendingMap = immutableSortedMap;
    }

    @Override
    public int size() {
        return this.valueList.size();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        ImmutableList immutableList = this.keySet.asList();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            biConsumer.accept(immutableList.get(i2), this.valueList.get(i2));
        }
    }

    @Override
    public V get(Object object) {
        int n2 = this.keySet.indexOf(object);
        return n2 == -1 ? null : (V)this.valueList.get(n2);
    }

    @Override
    boolean isPartialView() {
        return this.keySet.isPartialView() || this.valueList.isPartialView();
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        class EntrySet
        extends ImmutableMapEntrySet<K, V> {
            EntrySet() {
            }

            @Override
            public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                return this.asList().iterator();
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return this.asList().spliterator();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
                this.asList().forEach(consumer);
            }

            @Override
            ImmutableList<Map.Entry<K, V>> createAsList() {
                return new ImmutableAsList<Map.Entry<K, V>>(){

                    @Override
                    public Map.Entry<K, V> get(int n2) {
                        return new AbstractMap.SimpleImmutableEntry(ImmutableSortedMap.this.keySet.asList().get(n2), ImmutableSortedMap.this.valueList.get(n2));
                    }

                    @Override
                    public Spliterator<Map.Entry<K, V>> spliterator() {
                        return CollectSpliterators.indexed(this.size(), 1297, n2 -> this.get(n2));
                    }

                    @Override
                    ImmutableCollection<Map.Entry<K, V>> delegateCollection() {
                        return this;
                    }
                };
            }

            @Override
            ImmutableMap<K, V> map() {
                return ImmutableSortedMap.this;
            }
        }
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet();
    }

    @Override
    public ImmutableSortedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    ImmutableSet<K> createKeySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableCollection<V> values() {
        return this.valueList;
    }

    @Override
    ImmutableCollection<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((ImmutableSortedSet)this.keySet()).comparator();
    }

    @Override
    public K firstKey() {
        return (K)((ImmutableSortedSet)this.keySet()).first();
    }

    @Override
    public K lastKey() {
        return (K)((ImmutableSortedSet)this.keySet()).last();
    }

    private ImmutableSortedMap<K, V> getSubMap(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        if (n2 == n3) {
            return ImmutableSortedMap.emptyMap(this.comparator());
        }
        return new ImmutableSortedMap<K, V>(this.keySet.getSubSet(n2, n3), this.valueList.subList(n2, n3));
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k2) {
        return this.headMap((Object)k2, false);
    }

    @Override
    public ImmutableSortedMap<K, V> headMap(K k2, boolean bl2) {
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(k2), bl2));
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k2, K k3) {
        return this.subMap((Object)k2, true, (Object)k3, false);
    }

    @Override
    public ImmutableSortedMap<K, V> subMap(K k2, boolean bl2, K k3, boolean bl3) {
        Preconditions.checkNotNull(k2);
        Preconditions.checkNotNull(k3);
        Preconditions.checkArgument(this.comparator().compare(k2, k3) <= 0, "expected fromKey <= toKey but %s > %s", k2, k3);
        return ((ImmutableSortedMap)this.headMap((Object)k3, bl3)).tailMap((Object)k2, bl2);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k2) {
        return this.tailMap((Object)k2, true);
    }

    @Override
    public ImmutableSortedMap<K, V> tailMap(K k2, boolean bl2) {
        return this.getSubMap(this.keySet.tailIndex(Preconditions.checkNotNull(k2), bl2), this.size());
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K k2) {
        return ((ImmutableSortedMap)this.headMap((Object)k2, false)).lastEntry();
    }

    @Override
    public K lowerKey(K k2) {
        return Maps.keyOrNull(this.lowerEntry(k2));
    }

    @Override
    public Map.Entry<K, V> floorEntry(K k2) {
        return ((ImmutableSortedMap)this.headMap((Object)k2, true)).lastEntry();
    }

    @Override
    public K floorKey(K k2) {
        return Maps.keyOrNull(this.floorEntry(k2));
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K k2) {
        return ((ImmutableSortedMap)this.tailMap((Object)k2, true)).firstEntry();
    }

    @Override
    public K ceilingKey(K k2) {
        return Maps.keyOrNull(this.ceilingEntry(k2));
    }

    @Override
    public Map.Entry<K, V> higherEntry(K k2) {
        return ((ImmutableSortedMap)this.tailMap((Object)k2, false)).firstEntry();
    }

    @Override
    public K higherKey(K k2) {
        return Maps.keyOrNull(this.higherEntry(k2));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.isEmpty() ? null : (Map.Entry)((ImmutableCollection)((Object)this.entrySet())).asList().get(0);
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.isEmpty() ? null : (Map.Entry)((ImmutableCollection)((Object)this.entrySet())).asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableSortedMap<K, V> descendingMap() {
        ImmutableSortedMap<K, V> immutableSortedMap = this.descendingMap;
        if (immutableSortedMap == null) {
            if (this.isEmpty()) {
                return ImmutableSortedMap.emptyMap(Ordering.from(this.comparator()).reverse());
            }
            return new ImmutableSortedMap<K, V>((RegularImmutableSortedSet)this.keySet.descendingSet(), this.valueList.reverse(), this);
        }
        return immutableSortedMap;
    }

    @Override
    public ImmutableSortedSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public ImmutableSortedSet<K> descendingKeySet() {
        return this.keySet.descendingSet();
    }

    public static class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        private final Comparator<? super K> comparator;

        public Builder(Comparator<? super K> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @Override
        public Builder<K, V> put(K k2, V v2) {
            super.put(k2, v2);
            return this;
        }

        @Override
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            super.put(entry);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable) {
            super.putAll(iterable);
            return this;
        }

        @Override
        Builder<K, V> combine(ImmutableMap.Builder<K, V> builder) {
            super.combine(builder);
            return this;
        }

        @Override
        public ImmutableSortedMap<K, V> build() {
            return this.buildOrThrow();
        }

        @Override
        public ImmutableSortedMap<K, V> buildOrThrow() {
            switch (this.size) {
                case 0: {
                    return ImmutableSortedMap.emptyMap(this.comparator);
                }
                case 1: {
                    Map.Entry entry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableSortedMap.of(this.comparator, entry.getKey(), entry.getValue());
                }
            }
            return ImmutableSortedMap.fromEntries(this.comparator, false, this.entries, this.size);
        }

        @Override
        @Deprecated
        public final ImmutableSortedMap<K, V> buildKeepingLast() {
            throw new UnsupportedOperationException("ImmutableSortedMap.Builder does not yet implement buildKeepingLast()");
        }
    }
}

