/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.expression.Expression;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractJavaEntity;
import java.util.List;

public class DefaultJavaField
extends AbstractJavaEntity
implements JavaField {
    private JavaClass type;
    private String initializationExpression;
    private boolean enumConstant;
    private JavaClass enumConstantClass;
    private List<Expression> enumConstantArguments;

    public DefaultJavaField(String string) {
        this.setName(string);
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    public void setType(JavaClass javaClass) {
        this.type = javaClass;
    }

    @Override
    public String getInitializationExpression() {
        return this.initializationExpression;
    }

    public void setInitializationExpression(String string) {
        this.initializationExpression = string;
    }

    @Override
    public boolean isEnumConstant() {
        return this.enumConstant;
    }

    public void setEnumConstant(boolean bl2) {
        this.enumConstant = bl2;
    }

    @Override
    public List<Expression> getEnumConstantArguments() {
        return this.enumConstantArguments;
    }

    public void setEnumConstantArguments(List<Expression> list) {
        this.enumConstantArguments = list;
    }

    @Override
    public JavaClass getEnumConstantClass() {
        return this.enumConstantClass;
    }

    public void setEnumConstantClass(JavaClass javaClass) {
        this.enumConstantClass = javaClass;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isPrivate()) {
            stringBuilder.append("private ");
        } else if (this.isProtected()) {
            stringBuilder.append("protected ");
        } else if (this.isPublic()) {
            stringBuilder.append("public ");
        }
        if (this.isStatic()) {
            stringBuilder.append("static ");
        }
        if (this.isFinal()) {
            stringBuilder.append("final ");
        }
        if (this.isTransient()) {
            stringBuilder.append("transient ");
        }
        if (this.isVolatile()) {
            stringBuilder.append("volatile ");
        }
        stringBuilder.append(this.type.getValue()).append(' ');
        stringBuilder.append(this.getDeclaringClass().getFullyQualifiedName()).append('.').append(this.getName());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaField)) {
            return false;
        }
        JavaField javaField = (JavaField)object;
        if (!javaField.getDeclaringClass().equals(this.getDeclaringClass())) {
            return false;
        }
        if (!javaField.isEnumConstant() == this.isEnumConstant()) {
            return false;
        }
        return javaField.getName().equals(this.getName());
    }

    public int hashCode() {
        int n2 = 5;
        if (this.getDeclaringClass() != null) {
            n2 *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            n2 *= 37 + this.getName().hashCode();
        }
        return n2;
    }
}

