/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModule;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractJavaModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DefaultJavaModuleDescriptor
implements JavaModuleDescriptor {
    private String name;
    private Collection<DefaultJavaRequires> requires = new ArrayList<DefaultJavaRequires>();
    private Collection<DefaultJavaExports> exports = new ArrayList<DefaultJavaExports>();
    private Collection<DefaultJavaOpens> opens = new ArrayList<DefaultJavaOpens>();
    private Collection<DefaultJavaUses> uses = new ArrayList<DefaultJavaUses>();
    private Collection<DefaultJavaProvides> provides = new ArrayList<DefaultJavaProvides>();

    public DefaultJavaModuleDescriptor(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addExports(DefaultJavaExports defaultJavaExports) {
        this.exports.add(defaultJavaExports);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaExports> getExports() {
        return Collections.unmodifiableCollection(this.exports);
    }

    public void addOpens(DefaultJavaOpens defaultJavaOpens) {
        this.opens.add(defaultJavaOpens);
    }

    public void addRequires(DefaultJavaRequires defaultJavaRequires) {
        this.requires.add(defaultJavaRequires);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaRequires> getRequires() {
        return Collections.unmodifiableCollection(this.requires);
    }

    public void addProvides(DefaultJavaProvides defaultJavaProvides) {
        this.provides.add(defaultJavaProvides);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaProvides> getProvides() {
        return Collections.unmodifiableCollection(this.provides);
    }

    public void addUses(DefaultJavaUses defaultJavaUses) {
        this.uses.add(defaultJavaUses);
    }

    @Override
    public Collection<JavaModuleDescriptor.JavaUses> getUses() {
        return Collections.unmodifiableCollection(this.uses);
    }

    public static class DefaultJavaUses
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaUses {
        private JavaClass service;

        public DefaultJavaUses(JavaClass javaClass) {
            this.service = javaClass;
        }

        @Override
        public JavaClass getService() {
            return this.service;
        }
    }

    public static class DefaultJavaRequires
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaRequires {
        private JavaModule module;
        private Collection<String> modifiers;

        public DefaultJavaRequires(JavaModule javaModule, Collection<String> collection) {
            this.module = javaModule;
            this.modifiers = collection;
        }

        @Override
        public JavaModule getModule() {
            return this.module;
        }

        @Override
        public boolean isTransitive() {
            return this.getModifiers().contains("transitive");
        }

        @Override
        public boolean isStatic() {
            return this.getModifiers().contains("static");
        }

        public Collection<String> getModifiers() {
            if (this.modifiers == null) {
                return Collections.emptyList();
            }
            return this.modifiers;
        }
    }

    public static class DefaultJavaProvides
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaProvides {
        private JavaClass service;
        private List<JavaClass> providers;

        public DefaultJavaProvides(JavaClass javaClass, List<JavaClass> list) {
            this.service = javaClass;
            this.providers = list;
        }

        @Override
        public JavaClass getService() {
            return this.service;
        }

        public List<JavaClass> getProviders() {
            return this.providers;
        }
    }

    public static class DefaultJavaOpens
    extends AbstractJavaModel {
        private JavaPackage source;
        private Collection<JavaModule> targets;

        public DefaultJavaOpens(JavaPackage javaPackage, Collection<JavaModule> collection) {
            this.source = javaPackage;
            this.targets = collection;
        }
    }

    public static class DefaultJavaExports
    extends AbstractJavaModel
    implements JavaModuleDescriptor.JavaExports {
        private JavaPackage source;
        private Collection<JavaModule> targets;

        public DefaultJavaExports(JavaPackage javaPackage, Collection<JavaModule> collection) {
            this.source = javaPackage;
            this.targets = collection;
        }

        @Override
        public JavaPackage getSource() {
            return this.source;
        }

        @Override
        public Collection<JavaModule> getTargets() {
            if (this.targets == null) {
                return Collections.emptyList();
            }
            return this.targets;
        }
    }
}

