/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.client.entity;

import com.gradle.maven.extension.internal.dep.org.apache.http.HttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.NameValuePair;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.entity.GzipCompressingEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.AbstractHttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.BasicHttpEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.ByteArrayEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.ContentType;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.FileEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.InputStreamEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.SerializableEntity;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.StringEntity;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;

public class EntityBuilder {
    private String text;
    private byte[] binary;
    private InputStream stream;
    private List<NameValuePair> parameters;
    private Serializable serializable;
    private File file;
    private ContentType contentType;
    private String contentEncoding;
    private boolean chunked;
    private boolean gzipCompress;

    EntityBuilder() {
    }

    public static EntityBuilder create() {
        return new EntityBuilder();
    }

    private void clearContent() {
        this.text = null;
        this.binary = null;
        this.stream = null;
        this.parameters = null;
        this.serializable = null;
        this.file = null;
    }

    public EntityBuilder setBinary(byte[] byArray) {
        this.clearContent();
        this.binary = byArray;
        return this;
    }

    public EntityBuilder setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    private ContentType getContentOrDefault(ContentType contentType) {
        return this.contentType != null ? this.contentType : contentType;
    }

    public HttpEntity build() {
        AbstractHttpEntity abstractHttpEntity;
        if (this.text != null) {
            abstractHttpEntity = new StringEntity(this.text, this.getContentOrDefault(ContentType.DEFAULT_TEXT));
        } else if (this.binary != null) {
            abstractHttpEntity = new ByteArrayEntity(this.binary, this.getContentOrDefault(ContentType.DEFAULT_BINARY));
        } else if (this.stream != null) {
            abstractHttpEntity = new InputStreamEntity(this.stream, -1L, this.getContentOrDefault(ContentType.DEFAULT_BINARY));
        } else if (this.parameters != null) {
            abstractHttpEntity = new UrlEncodedFormEntity(this.parameters, this.contentType != null ? this.contentType.getCharset() : null);
        } else if (this.serializable != null) {
            abstractHttpEntity = new SerializableEntity(this.serializable);
            abstractHttpEntity.setContentType(ContentType.DEFAULT_BINARY.toString());
        } else {
            abstractHttpEntity = this.file != null ? new FileEntity(this.file, this.getContentOrDefault(ContentType.DEFAULT_BINARY)) : new BasicHttpEntity();
        }
        if (abstractHttpEntity.getContentType() != null && this.contentType != null) {
            abstractHttpEntity.setContentType(this.contentType.toString());
        }
        abstractHttpEntity.setContentEncoding(this.contentEncoding);
        abstractHttpEntity.setChunked(this.chunked);
        if (this.gzipCompress) {
            return new GzipCompressingEntity(abstractHttpEntity);
        }
        return abstractHttpEntity;
    }
}

