/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn;

import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.Log;
import com.gradle.maven.extension.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.protocol.HttpClientContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.Lookup;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.SocketConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ConnectTimeoutException;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.DnsResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.HttpClientConnectionOperator;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.HttpHostConnectException;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ManagedHttpClientConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.SchemePortResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.UnsupportedSchemeException;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.socket.ConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.DefaultSchemePortResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.SystemDefaultDnsResolver;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class DefaultHttpClientConnectionOperator
implements HttpClientConnectionOperator {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    private final SchemePortResolver schemePortResolver;
    private final DnsResolver dnsResolver;

    public DefaultHttpClientConnectionOperator(Lookup<ConnectionSocketFactory> lookup, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        Args.notNull(lookup, "Socket factory registry");
        this.socketFactoryRegistry = lookup;
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
        this.dnsResolver = dnsResolver != null ? dnsResolver : SystemDefaultDnsResolver.INSTANCE;
    }

    private Lookup<ConnectionSocketFactory> getSocketFactoryRegistry(HttpContext httpContext) {
        Lookup<ConnectionSocketFactory> lookup = (Lookup<ConnectionSocketFactory>)httpContext.getAttribute("http.socket-factory-registry");
        if (lookup == null) {
            lookup = this.socketFactoryRegistry;
        }
        return lookup;
    }

    @Override
    public void connect(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, InetSocketAddress inetSocketAddress, int n2, SocketConfig socketConfig, HttpContext httpContext) throws IOException {
        InetAddress[] inetAddressArray;
        Lookup<ConnectionSocketFactory> lookup = this.getSocketFactoryRegistry(httpContext);
        ConnectionSocketFactory connectionSocketFactory = lookup.lookup(httpHost.getSchemeName());
        if (connectionSocketFactory == null) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported");
        }
        if (httpHost.getAddress() != null) {
            InetAddress[] inetAddressArray2 = new InetAddress[1];
            inetAddressArray = inetAddressArray2;
            inetAddressArray2[0] = httpHost.getAddress();
        } else {
            inetAddressArray = this.dnsResolver.resolve(httpHost.getHostName());
        }
        InetAddress[] inetAddressArray3 = inetAddressArray;
        int n3 = this.schemePortResolver.resolve(httpHost);
        for (int i2 = 0; i2 < inetAddressArray3.length; ++i2) {
            InetSocketAddress inetSocketAddress2;
            block15: {
                int n4;
                InetAddress inetAddress = inetAddressArray3[i2];
                boolean bl2 = i2 == inetAddressArray3.length - 1;
                Socket socket = connectionSocketFactory.createSocket(httpContext);
                socket.setSoTimeout(socketConfig.getSoTimeout());
                socket.setReuseAddress(socketConfig.isSoReuseAddress());
                socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
                socket.setKeepAlive(socketConfig.isSoKeepAlive());
                if (socketConfig.getRcvBufSize() > 0) {
                    socket.setReceiveBufferSize(socketConfig.getRcvBufSize());
                }
                if (socketConfig.getSndBufSize() > 0) {
                    socket.setSendBufferSize(socketConfig.getSndBufSize());
                }
                if ((n4 = socketConfig.getSoLinger()) >= 0) {
                    socket.setSoLinger(true, n4);
                }
                managedHttpClientConnection.bind(socket);
                inetSocketAddress2 = new InetSocketAddress(inetAddress, n3);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Connecting to " + inetSocketAddress2);
                }
                try {
                    socket = connectionSocketFactory.connectSocket(n2, socket, httpHost, inetSocketAddress2, inetSocketAddress, httpContext);
                    managedHttpClientConnection.bind(socket);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Connection established " + managedHttpClientConnection);
                    }
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (bl2) {
                        throw new ConnectTimeoutException(socketTimeoutException, httpHost, inetAddressArray3);
                    }
                }
                catch (ConnectException connectException) {
                    if (bl2) {
                        String string = connectException.getMessage();
                        throw "Connection timed out".equals(string) ? new ConnectTimeoutException(connectException, httpHost, inetAddressArray3) : new HttpHostConnectException(connectException, httpHost, inetAddressArray3);
                    }
                }
                catch (NoRouteToHostException noRouteToHostException) {
                    if (!bl2) break block15;
                    throw noRouteToHostException;
                }
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Connect to " + inetSocketAddress2 + " timed out. " + "Connection will be retried using another IP address");
        }
    }

    @Override
    public void upgrade(ManagedHttpClientConnection managedHttpClientConnection, HttpHost httpHost, HttpContext httpContext) throws IOException {
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        Lookup<ConnectionSocketFactory> lookup = this.getSocketFactoryRegistry(httpClientContext);
        ConnectionSocketFactory connectionSocketFactory = lookup.lookup(httpHost.getSchemeName());
        if (connectionSocketFactory == null) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol is not supported");
        }
        if (!(connectionSocketFactory instanceof LayeredConnectionSocketFactory)) {
            throw new UnsupportedSchemeException(httpHost.getSchemeName() + " protocol does not support connection upgrade");
        }
        LayeredConnectionSocketFactory layeredConnectionSocketFactory = (LayeredConnectionSocketFactory)connectionSocketFactory;
        Socket socket = managedHttpClientConnection.getSocket();
        int n2 = this.schemePortResolver.resolve(httpHost);
        socket = layeredConnectionSocketFactory.createLayeredSocket(socket, httpHost.getHostName(), n2, httpContext);
        managedHttpClientConnection.bind(socket);
    }
}

