/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.protocol;

import com.gradle.maven.extension.internal.dep.org.apache.http.HttpConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpInetConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.org.apache.http.ProtocolException;
import com.gradle.maven.extension.internal.dep.org.apache.http.ProtocolVersion;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpCoreContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        HttpCoreContext httpCoreContext = HttpCoreContext.adapt(httpContext);
        ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT") && protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!httpRequest.containsHeader("Host")) {
            HttpHost httpHost = httpCoreContext.getTargetHost();
            if (httpHost == null) {
                HttpConnection httpConnection = httpCoreContext.getConnection();
                if (httpConnection instanceof HttpInetConnection) {
                    InetAddress inetAddress = ((HttpInetConnection)httpConnection).getRemoteAddress();
                    int n2 = ((HttpInetConnection)httpConnection).getRemotePort();
                    if (inetAddress != null) {
                        httpHost = new HttpHost(inetAddress.getHostName(), n2);
                    }
                }
                if (httpHost == null) {
                    if (protocolVersion.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            httpRequest.addHeader("Host", httpHost.toHostString());
        }
    }
}

