/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.util;

import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.Serializable;

public final class ByteArrayBuffer
implements Serializable {
    private byte[] buffer;
    private int len;

    public ByteArrayBuffer(int n2) {
        Args.notNegative(n2, "Buffer capacity");
        this.buffer = new byte[n2];
    }

    private void expand(int n2) {
        byte[] byArray = new byte[Math.max(this.buffer.length << 1, n2)];
        System.arraycopy(this.buffer, 0, byArray, 0, this.len);
        this.buffer = byArray;
    }

    public void append(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + byArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len + n3;
        if (n4 > this.buffer.length) {
            this.expand(n4);
        }
        System.arraycopy(byArray, n2, this.buffer, this.len, n3);
        this.len = n4;
    }

    public void append(int n2) {
        int n3 = this.len + 1;
        if (n3 > this.buffer.length) {
            this.expand(n3);
        }
        this.buffer[this.len] = (byte)n2;
        this.len = n3;
    }

    public void append(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return;
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("off: " + n2 + " len: " + n3 + " b.length: " + cArray.length);
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.len;
        int n5 = n4 + n3;
        if (n5 > this.buffer.length) {
            this.expand(n5);
        }
        int n6 = n2;
        for (int i2 = n4; i2 < n5; ++i2) {
            char c2 = cArray[n6];
            this.buffer[i2] = c2 >= ' ' && c2 <= '~' || c2 >= '\u00a0' && c2 <= '\u00ff' || c2 == '\t' ? (int)c2 : 63;
            ++n6;
        }
        this.len = n5;
    }

    public void append(CharArrayBuffer charArrayBuffer, int n2, int n3) {
        if (charArrayBuffer == null) {
            return;
        }
        this.append(charArrayBuffer.buffer(), n2, n3);
    }

    public void clear() {
        this.len = 0;
    }

    public int byteAt(int n2) {
        return this.buffer[n2];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.len;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.buffer.length;
    }
}

