/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.version.JavaVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

abstract class AbstractBinaryModuleInfoParser
implements ModuleInfoParser {
    AbstractBinaryModuleInfoParser() {
    }

    @Override
    public JavaModuleDescriptor getModuleDescriptor(Path path) throws IOException {
        return this.getModuleDescriptor(path, JavaVersion.JAVA_SPECIFICATION_VERSION);
    }

    public JavaModuleDescriptor getModuleDescriptor(Path path, JavaVersion javaVersion) throws IOException {
        JavaModuleDescriptor javaModuleDescriptor;
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(path.resolve("module-info.class"), new OpenOption[0]);){
                javaModuleDescriptor = this.parse(inputStream);
            }
        }
        try (JarFile jarFile = new JarFile(path.toFile());){
            JarEntry jarEntry;
            if (path.toString().toLowerCase().endsWith(".jmod")) {
                jarEntry = jarFile.getJarEntry("classes/module-info.class");
            } else {
                Manifest manifest;
                jarEntry = jarFile.getJarEntry("module-info.class");
                if (jarEntry == null && (manifest = jarFile.getManifest()) != null && "true".equalsIgnoreCase(manifest.getMainAttributes().getValue("Multi-Release"))) {
                    int n2;
                    for (int i2 = n2 = Integer.valueOf(javaVersion.asMajor().getValue(1)).intValue(); i2 >= 9; --i2) {
                        String string = "META-INF/versions/" + i2 + "/module-info.class";
                        JarEntry jarEntry2 = jarFile.getJarEntry(string);
                        if (jarEntry2 == null) continue;
                        jarEntry = jarEntry2;
                        break;
                    }
                }
            }
            javaModuleDescriptor = jarEntry != null ? this.parse(jarFile.getInputStream(jarEntry)) : null;
        }
        return javaModuleDescriptor;
    }

    abstract JavaModuleDescriptor parse(InputStream var1) throws IOException;
}

