/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.PlexusResource;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.resource.loader.URLPlexusResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="url")
public class URLResourceLoader
extends AbstractResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLResourceLoader.class);
    protected Map<String, String> templateRoots = new HashMap<String, String>();

    @Override
    public PlexusResource getResource(String string) throws ResourceNotFoundException {
        if (string == null || string.length() == 0) {
            throw new ResourceNotFoundException("URLResourceLoader : No template name provided");
        }
        for (Object object : this.paths) {
            try {
                URL uRL = new URL((String)object + string);
                final InputStream inputStream = uRL.openStream();
                if (inputStream == null) continue;
                LOGGER.debug("URLResourceLoader: Found '{}' at '{}'", (Object)string, object);
                this.templateRoots.put(string, (String)object);
                return new URLPlexusResource(uRL){
                    private boolean useSuper;

                    @Override
                    public synchronized InputStream getInputStream() throws IOException {
                        if (!this.useSuper) {
                            this.useSuper = true;
                            return inputStream;
                        }
                        return super.getInputStream();
                    }
                };
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.debug("URLResourceLoader: No valid URL '{}{}'", object, (Object)string);
            }
            catch (IOException iOException) {
                LOGGER.debug("URLResourceLoader: Exception when looking for '{}' at '{}'", new Object[]{string, object, iOException});
            }
        }
        try {
            Object object;
            URL uRL = new URL(string);
            object = uRL.openStream();
            if (object != null) {
                return new URLPlexusResource(uRL, (InputStream)object){
                    private boolean useSuper;
                    final /* synthetic */ InputStream val$inputStream;
                    {
                        this.val$inputStream = inputStream;
                        super(uRL);
                    }

                    @Override
                    public synchronized InputStream getInputStream() throws IOException {
                        if (!this.useSuper) {
                            this.useSuper = true;
                            return this.val$inputStream;
                        }
                        return super.getInputStream();
                    }
                };
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.debug("URLResourceLoader: No valid URL '{}'", (Object)string);
        }
        catch (IOException iOException) {
            LOGGER.debug("URLResourceLoader: Exception when looking for '{}'", (Object)string, (Object)iOException);
        }
        throw new ResourceNotFoundException(string);
    }
}

