/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLeafSnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class MerkleDirectorySnapshotBuilder
implements DirectorySnapshotBuilder {
    private static final HashCode DIR_SIGNATURE = Hashing.signature("DIR");
    private final Deque<Directory> directoryStack = new ArrayDeque<Directory>();
    private final boolean sortingRequired;
    private FileSystemLocationSnapshot result;

    public static DirectorySnapshotBuilder sortingRequired() {
        return new MerkleDirectorySnapshotBuilder(true);
    }

    public static DirectorySnapshotBuilder noSortingRequired() {
        return new MerkleDirectorySnapshotBuilder(false);
    }

    protected MerkleDirectorySnapshotBuilder(boolean bl2) {
        this.sortingRequired = bl2;
    }

    @Override
    public void enterDirectory(FileMetadata.AccessType accessType, String string, String string2, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
        this.directoryStack.addLast(new Directory(accessType, string, string2, emptyDirectoryHandlingStrategy));
    }

    @Override
    public void visitLeafElement(FileSystemLeafSnapshot fileSystemLeafSnapshot) {
        this.collectEntry(fileSystemLeafSnapshot);
    }

    @Override
    public void visitDirectory(DirectorySnapshot directorySnapshot) {
        this.collectEntry(directorySnapshot);
    }

    @Override
    public FileSystemLocationSnapshot leaveDirectory() {
        DirectorySnapshot directorySnapshot = this.directoryStack.removeLast().fold();
        if (directorySnapshot != null) {
            this.collectEntry(directorySnapshot);
        }
        return directorySnapshot;
    }

    private void collectEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot) {
        Directory directory = this.directoryStack.peekLast();
        if (directory != null) {
            directory.collectEntry(fileSystemLocationSnapshot);
        } else {
            assert (this.result == null);
            this.result = fileSystemLocationSnapshot;
        }
    }

    @Override
    public FileSystemLocationSnapshot getResult() {
        return this.result;
    }

    private class Directory {
        private final FileMetadata.AccessType accessType;
        private final String absolutePath;
        private final String name;
        private final List<FileSystemLocationSnapshot> children;
        private final DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy;

        public Directory(FileMetadata.AccessType accessType, String string, String string2, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy emptyDirectoryHandlingStrategy) {
            this.accessType = accessType;
            this.absolutePath = string;
            this.name = string2;
            this.children = new ArrayList<FileSystemLocationSnapshot>();
            this.emptyDirectoryHandlingStrategy = emptyDirectoryHandlingStrategy;
        }

        public void collectEntry(FileSystemLocationSnapshot fileSystemLocationSnapshot) {
            this.children.add(fileSystemLocationSnapshot);
        }

        public DirectorySnapshot fold() {
            if (this.emptyDirectoryHandlingStrategy == DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.EXCLUDE_EMPTY_DIRS && this.children.isEmpty()) {
                return null;
            }
            if (MerkleDirectorySnapshotBuilder.this.sortingRequired) {
                this.children.sort(FileSystemLocationSnapshot.BY_NAME);
            }
            Hasher hasher = Hashing.newHasher();
            hasher.putHash(DIR_SIGNATURE);
            for (FileSystemLocationSnapshot fileSystemLocationSnapshot : this.children) {
                hasher.putString(fileSystemLocationSnapshot.getName());
                hasher.putHash(fileSystemLocationSnapshot.getHash());
            }
            return new DirectorySnapshot(this.absolutePath, this.name, this.accessType, hasher.hash(), this.children);
        }
    }
}

