/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class AsciiReader
extends BaseReader {
    boolean mXml11 = false;
    int mCharCount = 0;

    public AsciiReader(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2) {
        super(readerConfig, inputStream, byArray, n2, n3, bl2);
    }

    @Override
    public void setXmlCompliancy(int n2) {
        this.mXml11 = n2 == 272;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        if (n2 < 0 || n2 + n3 > cArray.length) {
            this.reportBounds(cArray, n2, n3);
        }
        if (this.mByteBuffer == null) {
            return -1;
        }
        if (n3 < 1) {
            return 0;
        }
        int n5 = this.mByteBufferEnd - this.mBytePtr;
        if (n5 <= 0) {
            this.mCharCount += this.mByteBufferEnd;
            n4 = this.readBytes();
            if (n4 <= 0) {
                if (n4 == 0) {
                    this.reportStrangeStream();
                }
                this.freeBuffers();
                return -1;
            }
            n5 = n4;
        }
        if (n3 > n5) {
            n3 = n5;
        }
        n4 = this.mBytePtr;
        int n6 = n4 + n3;
        while (n4 < n6) {
            char c2;
            if ((c2 = (char)this.mByteBuffer[n4++]) >= '\u007f') {
                if (c2 > '\u007f') {
                    this.reportInvalidAscii(c2);
                } else if (this.mXml11) {
                    int n7 = this.mCharCount + this.mBytePtr;
                    this.reportInvalidXml11(c2, n7, n7);
                }
            }
            cArray[n2++] = c2;
        }
        this.mBytePtr = n6;
        return n3;
    }

    private void reportInvalidAscii(char c2) throws IOException {
        throw new CharConversionException("Invalid ascii byte; value above 7-bit ascii range (" + c2 + "; at pos #" + (this.mCharCount + this.mBytePtr) + ")");
    }
}

