/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.Comparator;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberType
extends BuiltinAtomicType
implements Comparator {
    public static final NumberType theInstance = new NumberType();
    private static final BigInteger the10 = new BigInteger("10");
    private static final long serialVersionUID = 1L;

    private NumberType() {
        super("decimal");
    }

    @Override
    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    @Override
    protected boolean checkFormat(String string, ValidationContext validationContext) {
        int n2 = string.length();
        int n3 = 0;
        boolean bl2 = false;
        if (n2 == 0) {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 == '-' || c2 == '+') {
            ++n3;
        }
        while (n3 < n2) {
            if ('0' <= (c2 = string.charAt(n3++)) && c2 <= '9') {
                bl2 = true;
                continue;
            }
            if (c2 == '.') break;
            return false;
        }
        while (n3 < n2) {
            if ('0' <= (c2 = string.charAt(n3++)) && c2 <= '9') {
                bl2 = true;
                continue;
            }
            return false;
        }
        return bl2;
    }

    @Override
    public Object _createValue(String string, ValidationContext validationContext) {
        if (!this.checkFormat(string, validationContext)) {
            return null;
        }
        return NumberType.load(string);
    }

    public static BigDecimal load(String string) {
        try {
            BigInteger[] bigIntegerArray;
            if (string.length() == 0) {
                return null;
            }
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            BigDecimal bigDecimal = new BigDecimal(string);
            while (bigDecimal.scale() > 0 && (bigIntegerArray = bigDecimal.unscaledValue().divideAndRemainder(the10))[1].equals(BigInteger.ZERO)) {
                bigDecimal = new BigDecimal(bigIntegerArray[0], bigDecimal.scale() - 1);
            }
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String save(Object object) {
        return ((BigDecimal)object).toString();
    }

    @Override
    public Class getJavaObjectType() {
        return BigDecimal.class;
    }

    @Override
    public String convertToLexicalValue(Object object, SerializationContext serializationContext) {
        if (object instanceof BigDecimal) {
            return object.toString();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final int isFacetApplicable(String string) {
        if (string.equals("totalDigits") || string.equals("fractionDigits") || string.equals("pattern") || string.equals("enumeration") || string.equals("whiteSpace") || string.equals("maxInclusive") || string.equals("minInclusive") || string.equals("maxExclusive") || string.equals("minExclusive")) {
            return 0;
        }
        return -2;
    }

    @Override
    public final int compare(Object object, Object object2) {
        int n2 = ((Comparable)object).compareTo(object2);
        if (n2 < 0) {
            return -1;
        }
        if (n2 > 0) {
            return 1;
        }
        return 0;
    }
}

