/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.DataUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

public final class BijectiveNsMap {
    static final int DEFAULT_ARRAY_SIZE = 32;
    private static final int MAX_LOOP_FOR_NEW_PREFIX = 999999;
    final int mScopeStart;
    String[] mNsStrings;
    int mScopeEnd;

    private BijectiveNsMap(int n2, String[] stringArray) {
        this.mScopeStart = this.mScopeEnd = n2;
        this.mNsStrings = stringArray;
    }

    public static BijectiveNsMap createEmpty() {
        String[] stringArray = new String[32];
        stringArray[0] = "xml";
        stringArray[1] = "http://www.w3.org/XML/1998/namespace";
        stringArray[2] = "xmlns";
        stringArray[3] = "http://www.w3.org/2000/xmlns/";
        return new BijectiveNsMap(4, stringArray);
    }

    public BijectiveNsMap createChild() {
        return new BijectiveNsMap(this.mScopeEnd, this.mNsStrings);
    }

    public String findUriByPrefix(String string) {
        String[] stringArray = this.mNsStrings;
        int n2 = string.hashCode();
        for (int i2 = this.mScopeEnd - 2; i2 >= 0; i2 -= 2) {
            String string2 = stringArray[i2];
            if (string2 != string && (string2.hashCode() != n2 || !string2.equals(string))) continue;
            return stringArray[i2 + 1];
        }
        return null;
    }

    public String findPrefixByUri(String string) {
        String[] stringArray = this.mNsStrings;
        int n2 = string.hashCode();
        block0: for (int i2 = this.mScopeEnd - 1; i2 > 0; i2 -= 2) {
            String string2 = stringArray[i2];
            if (string2 != string && (string2.hashCode() != n2 || !string2.equals(string))) continue;
            String string3 = stringArray[i2 - 1];
            if (i2 < this.mScopeStart) {
                int n3 = string3.hashCode();
                int n4 = this.mScopeEnd;
                for (int i3 = i2 + 1; i3 < n4; i3 += 2) {
                    String string4 = stringArray[i3];
                    if (string4 == string3 || string4.hashCode() == n3 && string4.equals(string3)) continue block0;
                }
            }
            return string3;
        }
        return null;
    }

    public List<String> getPrefixesBoundToUri(String string, List<String> list) {
        String[] stringArray = this.mNsStrings;
        int n2 = string.hashCode();
        block0: for (int i2 = this.mScopeEnd - 1; i2 > 0; i2 -= 2) {
            String string2 = stringArray[i2];
            if (string2 != string && (string2.hashCode() != n2 || !string2.equals(string))) continue;
            String string3 = stringArray[i2 - 1];
            if (i2 < this.mScopeStart) {
                int n3 = string3.hashCode();
                int n4 = this.mScopeEnd;
                for (int i3 = i2 + 1; i3 < n4; i3 += 2) {
                    String string4 = stringArray[i3];
                    if (string4 == string3 || string4.hashCode() == n3 && string4.equals(string3)) continue block0;
                }
            }
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(string3);
        }
        return list;
    }

    public int size() {
        return this.mScopeEnd >> 1;
    }

    public int localSize() {
        return this.mScopeEnd - this.mScopeStart >> 1;
    }

    public String addMapping(String string, String string2) {
        String[] stringArray = this.mNsStrings;
        int n2 = string.hashCode();
        int n3 = this.mScopeEnd;
        for (int i2 = this.mScopeStart; i2 < n3; i2 += 2) {
            String string3 = stringArray[i2];
            if (string3 != string && (string3.hashCode() != n2 || !string3.equals(string))) continue;
            String string4 = stringArray[i2 + 1];
            stringArray[i2 + 1] = string2;
            return string4;
        }
        if (this.mScopeEnd >= stringArray.length) {
            stringArray = DataUtil.growArrayBy(stringArray, stringArray.length);
            this.mNsStrings = stringArray;
        }
        stringArray[this.mScopeEnd++] = string;
        stringArray[this.mScopeEnd++] = string2;
        return null;
    }

    public String addGeneratedMapping(String string, NamespaceContext namespaceContext, String string2, int[] nArray) {
        String string3;
        int n2;
        String[] stringArray;
        block3: {
            stringArray = this.mNsStrings;
            n2 = nArray[0];
            int n3 = 0;
            block0: while (true) {
                String string4;
                string3 = (string + n2).intern();
                ++n2;
                int n4 = string3.hashCode();
                for (int i2 = this.mScopeEnd - 2; i2 >= 0; i2 -= 2) {
                    String string5 = stringArray[i2];
                    if (string5 == string3 || string5.hashCode() == n4 && string5.equals(string3)) continue block0;
                }
                if (namespaceContext == null || (string4 = namespaceContext.getNamespaceURI(string3)) == null || string4.isEmpty()) break block3;
                if (++n3 > 999999) break;
            }
            throw new IllegalStateException("Internal error: failed to find a mapping prefix for URI '" + string2 + " in " + 999999 + " attempts");
        }
        nArray[0] = n2;
        if (this.mScopeEnd >= stringArray.length) {
            stringArray = DataUtil.growArrayBy(stringArray, stringArray.length);
            this.mNsStrings = stringArray;
        }
        stringArray[this.mScopeEnd++] = string3;
        stringArray[this.mScopeEnd++] = string2;
        return string3;
    }

    public String toString() {
        return "[" + this.getClass().toString() + "; " + this.size() + " entries; of which " + this.localSize() + " local]";
    }
}

