/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.util;

import javax.xml.namespace.QName;

public final class PrefixedName
implements Comparable<PrefixedName> {
    private String mPrefix;
    private String mLocalName;
    volatile int mHash = 0;

    public PrefixedName(String string, String string2) {
        this.mLocalName = string2;
        this.mPrefix = string != null && string.length() == 0 ? null : string;
    }

    public PrefixedName reset(String string, String string2) {
        this.mLocalName = string2;
        this.mPrefix = string != null && string.length() == 0 ? null : string;
        this.mHash = 0;
        return this;
    }

    public static PrefixedName valueOf(QName qName) {
        return new PrefixedName(qName.getPrefix(), qName.getLocalPart());
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public boolean isaNsDeclaration() {
        if (this.mPrefix == null) {
            return this.mLocalName == "xmlns";
        }
        return this.mPrefix == "xmlns";
    }

    public boolean isXmlReservedAttr(boolean bl2, String string) {
        if (bl2) {
            if ("xml" == this.mPrefix) {
                return this.mLocalName == string;
            }
        } else if (this.mLocalName.length() == 4 + string.length()) {
            return this.mLocalName.startsWith("xml:") && this.mLocalName.endsWith(string);
        }
        return false;
    }

    public String toString() {
        if (this.mPrefix == null || this.mPrefix.length() == 0) {
            return this.mLocalName;
        }
        StringBuilder stringBuilder = new StringBuilder(this.mPrefix.length() + 1 + this.mLocalName.length());
        stringBuilder.append(this.mPrefix);
        stringBuilder.append(':');
        stringBuilder.append(this.mLocalName);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrefixedName)) {
            return false;
        }
        PrefixedName prefixedName = (PrefixedName)object;
        if (this.mLocalName != prefixedName.mLocalName) {
            return false;
        }
        return this.mPrefix == prefixedName.mPrefix;
    }

    public int hashCode() {
        int n2 = this.mHash;
        if (n2 == 0) {
            n2 = this.mLocalName.hashCode();
            if (this.mPrefix != null) {
                n2 ^= this.mPrefix.hashCode();
            }
            this.mHash = n2;
        }
        return n2;
    }

    @Override
    public int compareTo(PrefixedName prefixedName) {
        String string = prefixedName.mPrefix;
        if (string == null || string.length() == 0) {
            if (this.mPrefix != null && this.mPrefix.length() > 0) {
                return 1;
            }
        } else {
            if (this.mPrefix == null || this.mPrefix.length() == 0) {
                return -1;
            }
            int n2 = this.mPrefix.compareTo(string);
            if (n2 != 0) {
                return n2;
            }
        }
        return this.mLocalName.compareTo(prefixedName.mLocalName);
    }
}

