/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.bootstrap;

import com.gradle.maven.extension.internal.dep.io.netty.bootstrap.ChannelInitializerExtension;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogLevel;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;

abstract class ChannelInitializerExtensions {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelInitializerExtensions.class);
    private static volatile ChannelInitializerExtensions implementation;

    private ChannelInitializerExtensions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ChannelInitializerExtensions getExtensions() {
        ChannelInitializerExtensions channelInitializerExtensions = implementation;
        if (channelInitializerExtensions != null) return channelInitializerExtensions;
        Class<ChannelInitializerExtensions> clazz = ChannelInitializerExtensions.class;
        synchronized (ChannelInitializerExtensions.class) {
            channelInitializerExtensions = implementation;
            if (channelInitializerExtensions != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return channelInitializerExtensions;
            }
            String string = SystemPropertyUtil.get("com.gradle.maven.extension.internal.dep.io.netty.bootstrap.extensions");
            logger.debug("-Dio.netty.bootstrap.extensions: {}", (Object)string);
            channelInitializerExtensions = "serviceload".equalsIgnoreCase(string) ? new ServiceLoadingExtensions(InternalLogLevel.DEBUG, true) : ("log".equalsIgnoreCase(string) ? new ServiceLoadingExtensions(InternalLogLevel.INFO, false) : new EmptyExtensions());
            implementation = channelInitializerExtensions;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return channelInitializerExtensions;
        }
    }

    abstract Collection<ChannelInitializerExtension> extensions(ClassLoader var1);

    private static final class ServiceLoadingExtensions
    extends ChannelInitializerExtensions {
        private final InternalLogLevel logLevel;
        private final boolean loadAndCache;
        private WeakReference<ClassLoader> classLoader;
        private Collection<ChannelInitializerExtension> extensions;

        ServiceLoadingExtensions(InternalLogLevel internalLogLevel, boolean bl2) {
            this.logLevel = internalLogLevel;
            this.loadAndCache = bl2;
        }

        @Override
        synchronized Collection<ChannelInitializerExtension> extensions(ClassLoader classLoader) {
            ClassLoader classLoader2;
            ClassLoader classLoader3 = classLoader2 = this.classLoader == null ? null : (ClassLoader)this.classLoader.get();
            if (classLoader2 == null || classLoader2 != classLoader) {
                Collection<ChannelInitializerExtension> collection = ServiceLoadingExtensions.serviceLoadExtensions(this.logLevel, classLoader);
                this.classLoader = new WeakReference<ClassLoader>(classLoader);
                this.extensions = this.loadAndCache ? collection : Collections.emptyList();
            }
            return this.extensions;
        }

        private static Collection<ChannelInitializerExtension> serviceLoadExtensions(InternalLogLevel internalLogLevel, ClassLoader classLoader) {
            ArrayList<ChannelInitializerExtension> arrayList = new ArrayList<ChannelInitializerExtension>();
            ServiceLoader<ChannelInitializerExtension> serviceLoader = ServiceLoader.load(ChannelInitializerExtension.class, classLoader);
            for (ChannelInitializerExtension channelInitializerExtension : serviceLoader) {
                logger.log(internalLogLevel, "Loaded extension: {}", channelInitializerExtension.getClass());
                arrayList.add(channelInitializerExtension);
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList, new Comparator<ChannelInitializerExtension>(){

                    @Override
                    public int compare(ChannelInitializerExtension channelInitializerExtension, ChannelInitializerExtension channelInitializerExtension2) {
                        return Double.compare(channelInitializerExtension.priority(), channelInitializerExtension2.priority());
                    }
                });
                return Collections.unmodifiableList(arrayList);
            }
            return Collections.emptyList();
        }
    }

    private static final class EmptyExtensions
    extends ChannelInitializerExtensions {
        private EmptyExtensions() {
        }

        @Override
        Collection<ChannelInitializerExtension> extensions(ClassLoader classLoader) {
            return Collections.emptyList();
        }
    }
}

