/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.FullHttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMessageUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponseStatus;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpResponse
extends DefaultHttpResponse
implements FullHttpResponse {
    private final ByteBuf content;
    private final HttpHeaders trailingHeaders;
    private int hash;

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf) {
        this(httpVersion, httpResponseStatus, byteBuf, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, HttpHeadersFactory httpHeadersFactory, HttpHeadersFactory httpHeadersFactory2) {
        this(httpVersion, httpResponseStatus, byteBuf, httpHeadersFactory.newHeaders(), httpHeadersFactory2.newHeaders());
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2) {
        super(httpVersion, httpResponseStatus, httpHeaders);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeaders = ObjectUtil.checkNotNull(httpHeaders2, "trailingHeaders");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpResponse retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpResponse touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public FullHttpResponse retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    public FullHttpResponse replace(ByteBuf byteBuf) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.protocolVersion(), this.status(), byteBuf, this.headers().copy(), this.trailingHeaders().copy());
        defaultFullHttpResponse.setDecoderResult(this.decoderResult());
        return defaultFullHttpResponse;
    }

    @Override
    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            if (ByteBufUtil.isAccessible(this.content())) {
                try {
                    n2 = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {
                    n2 = 31;
                }
            } else {
                n2 = 31;
            }
            n2 = 31 * n2 + this.trailingHeaders().hashCode();
            this.hash = n2 = 31 * n2 + super.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpResponse)) {
            return false;
        }
        DefaultFullHttpResponse defaultFullHttpResponse = (DefaultFullHttpResponse)object;
        return super.equals(defaultFullHttpResponse) && this.content().equals(defaultFullHttpResponse.content()) && this.trailingHeaders().equals(defaultFullHttpResponse.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
    }
}

