/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.proxy;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.buffer.Unpooled;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelInboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelOutboundHandler;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.maven.extension.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.base64.Base64;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpClientCodec;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpResponseStatus;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpUtil;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.http.LastHttpContent;
import com.gradle.maven.extension.internal.dep.io.netty.handler.proxy.ProxyConnectException;
import com.gradle.maven.extension.internal.dep.io.netty.handler.proxy.ProxyHandler;
import com.gradle.maven.extension.internal.dep.io.netty.util.AsciiString;
import com.gradle.maven.extension.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class HttpProxyHandler
extends ProxyHandler {
    private final HttpClientCodecWrapper codecWrapper = new HttpClientCodecWrapper();
    private final String username;
    private final String password;
    private final CharSequence authorization;
    private final HttpHeaders outboundHeaders;
    private final boolean ignoreDefaultPortsInConnectHostHeader;
    private HttpResponseStatus status;
    private HttpHeaders inboundHeaders;

    public HttpProxyHandler(SocketAddress socketAddress) {
        this(socketAddress, null);
    }

    public HttpProxyHandler(SocketAddress socketAddress, HttpHeaders httpHeaders) {
        this(socketAddress, httpHeaders, false);
    }

    public HttpProxyHandler(SocketAddress socketAddress, HttpHeaders httpHeaders, boolean bl2) {
        super(socketAddress);
        this.username = null;
        this.password = null;
        this.authorization = null;
        this.outboundHeaders = httpHeaders;
        this.ignoreDefaultPortsInConnectHostHeader = bl2;
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2) {
        this(socketAddress, string, string2, null);
    }

    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2, HttpHeaders httpHeaders) {
        this(socketAddress, string, string2, httpHeaders, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpProxyHandler(SocketAddress socketAddress, String string, String string2, HttpHeaders httpHeaders, boolean bl2) {
        super(socketAddress);
        ByteBuf byteBuf;
        this.username = ObjectUtil.checkNotNull(string, "username");
        this.password = ObjectUtil.checkNotNull(string2, "password");
        ByteBuf byteBuf2 = Unpooled.copiedBuffer(string + ':' + string2, CharsetUtil.UTF_8);
        try {
            byteBuf = Base64.encode(byteBuf2, false);
        }
        finally {
            byteBuf2.release();
        }
        try {
            this.authorization = new AsciiString("Basic " + byteBuf.toString(CharsetUtil.US_ASCII));
        }
        finally {
            byteBuf.release();
        }
        this.outboundHeaders = httpHeaders;
        this.ignoreDefaultPortsInConnectHostHeader = bl2;
    }

    @Override
    public String protocol() {
        return "http";
    }

    @Override
    public String authScheme() {
        return this.authorization != null ? "basic" : "none";
    }

    @Override
    protected void addCodec(ChannelHandlerContext channelHandlerContext) throws Exception {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        String string = channelHandlerContext.name();
        channelPipeline.addBefore(string, null, this.codecWrapper);
    }

    @Override
    protected void removeEncoder(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.codecWrapper.codec.removeOutboundHandler();
    }

    @Override
    protected void removeDecoder(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.codecWrapper.codec.removeInboundHandler();
    }

    @Override
    protected Object newInitialMessage(ChannelHandlerContext channelHandlerContext) throws Exception {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)this.destinationAddress();
        String string = HttpUtil.formatHostnameForHttp(inetSocketAddress);
        int n2 = inetSocketAddress.getPort();
        String string2 = string + ":" + n2;
        String string3 = this.ignoreDefaultPortsInConnectHostHeader && (n2 == 80 || n2 == 443) ? string : string2;
        DefaultHttpHeadersFactory defaultHttpHeadersFactory = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, string2, Unpooled.EMPTY_BUFFER, defaultHttpHeadersFactory, defaultHttpHeadersFactory);
        defaultFullHttpRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)string3);
        if (this.authorization != null) {
            defaultFullHttpRequest.headers().set((CharSequence)HttpHeaderNames.PROXY_AUTHORIZATION, (Object)this.authorization);
        }
        if (this.outboundHeaders != null) {
            defaultFullHttpRequest.headers().add(this.outboundHeaders);
        }
        return defaultFullHttpRequest;
    }

    @Override
    protected boolean handleResponse(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        boolean bl2;
        if (object instanceof HttpResponse) {
            if (this.status != null) {
                throw new HttpProxyConnectException(this.exceptionMessage("too many responses"), null);
            }
            HttpResponse httpResponse = (HttpResponse)object;
            this.status = httpResponse.status();
            this.inboundHeaders = httpResponse.headers();
        }
        if (bl2 = object instanceof LastHttpContent) {
            if (this.status == null) {
                throw new HttpProxyConnectException(this.exceptionMessage("missing response"), this.inboundHeaders);
            }
            if (this.status.code() != 200) {
                throw new HttpProxyConnectException(this.exceptionMessage("status: " + this.status), this.inboundHeaders);
            }
        }
        return bl2;
    }

    private static final class HttpClientCodecWrapper
    implements ChannelInboundHandler,
    ChannelOutboundHandler {
        final HttpClientCodec codec = new HttpClientCodec();

        private HttpClientCodecWrapper() {
        }

        @Override
        public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.handlerAdded(channelHandlerContext);
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.handlerRemoved(channelHandlerContext);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
            this.codec.exceptionCaught(channelHandlerContext, throwable);
        }

        @Override
        public void channelRegistered(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelRegistered(channelHandlerContext);
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelUnregistered(channelHandlerContext);
        }

        @Override
        public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelActive(channelHandlerContext);
        }

        @Override
        public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelInactive(channelHandlerContext);
        }

        @Override
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            this.codec.channelRead(channelHandlerContext, object);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelReadComplete(channelHandlerContext);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            this.codec.userEventTriggered(channelHandlerContext, object);
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.channelWritabilityChanged(channelHandlerContext);
        }

        @Override
        public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) throws Exception {
            this.codec.bind(channelHandlerContext, socketAddress, channelPromise);
        }

        @Override
        public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) throws Exception {
            this.codec.connect(channelHandlerContext, socketAddress, socketAddress2, channelPromise);
        }

        @Override
        public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
            this.codec.disconnect(channelHandlerContext, channelPromise);
        }

        @Override
        public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
            this.codec.close(channelHandlerContext, channelPromise);
        }

        @Override
        public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
            this.codec.deregister(channelHandlerContext, channelPromise);
        }

        @Override
        public void read(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.read(channelHandlerContext);
        }

        @Override
        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            this.codec.write(channelHandlerContext, object, channelPromise);
        }

        @Override
        public void flush(ChannelHandlerContext channelHandlerContext) throws Exception {
            this.codec.flush(channelHandlerContext);
        }
    }

    public static final class HttpProxyConnectException
    extends ProxyConnectException {
        private final HttpHeaders headers;

        public HttpProxyConnectException(String string, HttpHeaders httpHeaders) {
            super(string);
            this.headers = httpHeaders;
        }
    }
}

