/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.MethodExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypedValue;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectionHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectiveMethodExecutor
implements MethodExecutor {
    private final Method originalMethod;
    private final Method methodToInvoke;
    private final Integer varargsPosition;
    private boolean computedPublicDeclaringClass = false;
    private Class<?> publicDeclaringClass;
    private boolean argumentConversionOccurred = false;

    public ReflectiveMethodExecutor(Method method, Class<?> clazz) {
        this.originalMethod = method;
        this.methodToInvoke = ClassUtils.getInterfaceMethodIfPossible(method, clazz);
        this.varargsPosition = method.isVarArgs() ? Integer.valueOf(method.getParameterCount() - 1) : null;
    }

    public final Method getMethod() {
        return this.originalMethod;
    }

    public Class<?> getPublicDeclaringClass() {
        if (!this.computedPublicDeclaringClass) {
            this.publicDeclaringClass = this.discoverPublicDeclaringClass(this.originalMethod, this.originalMethod.getDeclaringClass());
            this.computedPublicDeclaringClass = true;
        }
        return this.publicDeclaringClass;
    }

    private Class<?> discoverPublicDeclaringClass(Method method, Class<?> clazz) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return clazz;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (clazz.getSuperclass() != null) {
            return this.discoverPublicDeclaringClass(method, clazz.getSuperclass());
        }
        return null;
    }

    public boolean didArgumentConversionOccur() {
        return this.argumentConversionOccurred;
    }

    @Override
    public TypedValue execute(EvaluationContext evaluationContext, Object object, Object ... objectArray) throws AccessException {
        try {
            this.argumentConversionOccurred = ReflectionHelper.convertArguments(evaluationContext.getTypeConverter(), objectArray, this.originalMethod, this.varargsPosition);
            if (this.originalMethod.isVarArgs()) {
                objectArray = ReflectionHelper.setupArgumentsForVarargsInvocation(this.originalMethod.getParameterTypes(), objectArray);
            }
            ReflectionUtils.makeAccessible(this.methodToInvoke);
            Object object2 = this.methodToInvoke.invoke(object, objectArray);
            return new TypedValue(object2, new TypeDescriptor(new MethodParameter(this.originalMethod, -1)).narrow(object2));
        }
        catch (Exception exception) {
            throw new AccessException("Problem invoking method: " + this.methodToInvoke, exception);
        }
    }
}

