/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.gradle.api.internal.changedetection.state.LineEndingNormalizingInputStreamHasher;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.io.IoSupplier;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public class LineEndingNormalizingFileSystemLocationSnapshotHasher
implements FileSystemLocationSnapshotHasher {
    private final FileSystemLocationSnapshotHasher delegate;
    private final LineEndingNormalizingInputStreamHasher hasher;

    private LineEndingNormalizingFileSystemLocationSnapshotHasher(FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher) {
        this.delegate = fileSystemLocationSnapshotHasher;
        this.hasher = new LineEndingNormalizingInputStreamHasher();
    }

    public static FileSystemLocationSnapshotHasher wrap(FileSystemLocationSnapshotHasher fileSystemLocationSnapshotHasher, LineEndingSensitivity lineEndingSensitivity) {
        switch (lineEndingSensitivity) {
            case DEFAULT: {
                return fileSystemLocationSnapshotHasher;
            }
            case NORMALIZE_LINE_ENDINGS: {
                return new LineEndingNormalizingFileSystemLocationSnapshotHasher(fileSystemLocationSnapshotHasher);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
        hasher.putString(this.getClass().getName());
    }

    @Override
    public HashCode hash(FileSystemLocationSnapshot fileSystemLocationSnapshot) throws IOException {
        return this.hashContent(fileSystemLocationSnapshot).orElseGet(IoSupplier.wrap(() -> this.delegate.hash(fileSystemLocationSnapshot)));
    }

    private Optional<HashCode> hashContent(FileSystemLocationSnapshot fileSystemLocationSnapshot) throws IOException {
        return fileSystemLocationSnapshot.getType() == FileType.RegularFile ? this.hasher.hashContent(new File(fileSystemLocationSnapshot.getAbsolutePath())) : Optional.empty();
    }
}

