/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.BasicHeader;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Header;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Map;

class HeaderDeserializer
extends StdDeserializer<Header> {
    HeaderDeserializer() {
        super(Header.class);
    }

    @Override
    public Header deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Map<String, JsonNode> map = jsonParser.getCodec().readValue(jsonParser, new TypeReference<Map<String, JsonNode>>(){});
        if (map == null) {
            throw new JWTDecodeException("Parsing the Header's JSON resulted on a Null map");
        }
        String string = this.getString(map, "alg");
        String string2 = this.getString(map, "typ");
        String string3 = this.getString(map, "cty");
        String string4 = this.getString(map, "kid");
        return new BasicHeader(string, string2, string3, string4, map, jsonParser.getCodec());
    }

    String getString(Map<String, JsonNode> map, String string) {
        JsonNode jsonNode = map.get(string);
        if (jsonNode == null || jsonNode.isNull()) {
            return null;
        }
        return jsonNode.asText(null);
    }
}

