/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.stax;

import aQute.bnd.annotation.spi.ServiceProvider;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.WriterConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.cfg.OutputConfigFlags;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.dom.WstxDOMWrappingWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.exc.WstxIOException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.CharsetNames;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.UTF8Writer;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.AsciiXmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.BufferingXmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.ISOLatin1XmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.NonNsStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.RepairingNsStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.SimpleNsStreamWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.sw.XmlWriter;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.util.URLUtil;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLOutputFactory2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.XMLStreamWriter2;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.io.Stax2Result;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2EventWriterImpl;
import com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.Stax2WriterAdapter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;

@ServiceProvider(value=XMLOutputFactory.class)
public class WstxOutputFactory
extends XMLOutputFactory2
implements OutputConfigFlags {
    protected final WriterConfig mConfig = WriterConfig.createFullDefaults();

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(outputStream, null);
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String string) throws XMLStreamException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null OutputStream is not a valid argument");
        }
        return new Stax2EventWriterImpl(this.createSW(outputStream, null, string, false));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(result));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        if (writer == null) {
            throw new IllegalArgumentException("Null Writer is not a valid argument");
        }
        return new Stax2EventWriterImpl(this.createSW(null, writer, null, false));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLStreamWriter(outputStream, null);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String string) throws XMLStreamException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Null OutputStream is not a valid argument");
        }
        return this.createSW(outputStream, null, string, false);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        return this.createSW(result);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        if (writer == null) {
            throw new IllegalArgumentException("Null Writer is not a valid argument");
        }
        return this.createSW(null, writer, null, false);
    }

    @Override
    public Object getProperty(String string) {
        return this.mConfig.getProperty(string);
    }

    @Override
    public boolean isPropertySupported(String string) {
        return this.mConfig.isPropertySupported(string);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.mConfig.setProperty(string, object);
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer, String string) throws XMLStreamException {
        return new Stax2EventWriterImpl(this.createSW(null, writer, string, false));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        XMLStreamWriter2 xMLStreamWriter2 = Stax2WriterAdapter.wrapIfNecessary(xMLStreamWriter);
        return new Stax2EventWriterImpl(xMLStreamWriter2);
    }

    @Override
    public XMLStreamWriter2 createXMLStreamWriter(Writer writer, String string) throws XMLStreamException {
        return this.createSW(null, writer, string, false);
    }

    @Override
    public void configureForXmlConformance() {
        this.mConfig.configureForXmlConformance();
    }

    @Override
    public void configureForRobustness() {
        this.mConfig.configureForRobustness();
    }

    @Override
    public void configureForSpeed() {
        this.mConfig.configureForSpeed();
    }

    public WriterConfig getConfig() {
        return this.mConfig;
    }

    private XMLStreamWriter2 createSW(OutputStream outputStream, Writer writer, String string, boolean bl2) throws XMLStreamException {
        XmlWriter xmlWriter;
        boolean bl3;
        WriterConfig writerConfig = this.mConfig.createNonShared();
        boolean bl4 = bl3 = bl2 || this.mConfig.willAutoCloseOutput();
        if (writer == null) {
            if (string == null) {
                string = "UTF-8";
            } else if (string != "UTF-8" && string != "ISO-8859-1" && string != "US-ASCII") {
                string = CharsetNames.normalize(string);
            }
            try {
                if (string == "UTF-8") {
                    writer = new UTF8Writer(writerConfig, outputStream, bl3);
                    xmlWriter = new BufferingXmlWriter(writer, writerConfig, string, bl3, outputStream, 16);
                }
                if (string == "ISO-8859-1") {
                    xmlWriter = new ISOLatin1XmlWriter(outputStream, writerConfig, bl3);
                }
                if (string == "US-ASCII") {
                    xmlWriter = new AsciiXmlWriter(outputStream, writerConfig, bl3);
                }
                writer = new OutputStreamWriter(outputStream, string);
                xmlWriter = new BufferingXmlWriter(writer, writerConfig, string, bl3, outputStream, -1);
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        } else {
            if (string == null) {
                string = CharsetNames.findEncodingFor(writer);
            }
            try {
                xmlWriter = new BufferingXmlWriter(writer, writerConfig, string, bl3, null, -1);
            }
            catch (IOException iOException) {
                throw new XMLStreamException(iOException);
            }
        }
        return this.createSW(string, writerConfig, xmlWriter);
    }

    protected XMLStreamWriter2 createSW(String string, WriterConfig writerConfig, XmlWriter xmlWriter) {
        if (writerConfig.willSupportNamespaces()) {
            if (writerConfig.automaticNamespacesEnabled()) {
                return new RepairingNsStreamWriter(xmlWriter, string, writerConfig);
            }
            return new SimpleNsStreamWriter(xmlWriter, string, writerConfig);
        }
        return new NonNsStreamWriter(xmlWriter, string, writerConfig);
    }

    private XMLStreamWriter2 createSW(Result result) throws XMLStreamException {
        boolean bl2;
        Result result2;
        OutputStream outputStream = null;
        Writer writer = null;
        String string = null;
        String string2 = null;
        if (result instanceof Stax2Result) {
            result2 = (Stax2Result)result;
            try {
                outputStream = ((Stax2Result)result2).constructOutputStream();
                if (outputStream == null) {
                    writer = ((Stax2Result)result2).constructWriter();
                }
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
            bl2 = true;
        } else if (result instanceof StreamResult) {
            result2 = (StreamResult)result;
            outputStream = ((StreamResult)result2).getOutputStream();
            string2 = ((StreamResult)result2).getSystemId();
            if (outputStream == null) {
                writer = ((StreamResult)result2).getWriter();
            }
            bl2 = false;
        } else if (result instanceof SAXResult) {
            result2 = (SAXResult)result;
            string2 = ((SAXResult)result2).getSystemId();
            if (string2 == null || string2.length() == 0) {
                throw new XMLStreamException("Can not create a stream writer for a SAXResult that does not have System Id (support for using SAX input source not implemented)");
            }
            bl2 = true;
        } else {
            if (result instanceof DOMResult) {
                return WstxDOMWrappingWriter.createFrom(this.mConfig.createNonShared(), (DOMResult)result);
            }
            throw new IllegalArgumentException("Can not instantiate a writer for XML result type " + result.getClass() + " (unrecognized type)");
        }
        if (outputStream != null) {
            return this.createSW(outputStream, null, string, bl2);
        }
        if (writer != null) {
            return this.createSW(null, writer, string, bl2);
        }
        if (string2 != null && string2.length() > 0) {
            bl2 = true;
            try {
                outputStream = URLUtil.outputStreamFromURL(URLUtil.urlFromSystemId(string2));
            }
            catch (IOException iOException) {
                throw new WstxIOException(iOException);
            }
            return this.createSW(outputStream, null, string, bl2);
        }
        throw new XMLStreamException("Can not create Stax writer for passed-in Result -- neither writer, output stream or system id was accessible");
    }
}

