/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.BeanProperty;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.type.ReferenceType;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.BeanUtil;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;

public abstract class ReferenceTypeSerializer<T>
extends StdSerializer<T>
implements ContextualSerializer {
    public static final Object MARKER_FOR_EMPTY = JsonInclude.Include.NON_EMPTY;
    protected final JavaType _referredType;
    protected final BeanProperty _property;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final NameTransformer _unwrapper;
    protected transient PropertySerializerMap _dynamicSerializers;
    protected final Object _suppressableValue;
    protected final boolean _suppressNulls;

    public ReferenceTypeSerializer(ReferenceType referenceType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(referenceType);
        this._referredType = referenceType.getReferencedType();
        this._property = null;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._unwrapper = null;
        this._suppressableValue = null;
        this._suppressNulls = false;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    protected ReferenceTypeSerializer(ReferenceTypeSerializer<?> referenceTypeSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, NameTransformer nameTransformer, Object object, boolean bl2) {
        super(referenceTypeSerializer);
        this._referredType = referenceTypeSerializer._referredType;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._property = beanProperty;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._unwrapper = nameTransformer;
        this._suppressableValue = object;
        this._suppressNulls = bl2;
    }

    @Override
    public JsonSerializer<T> unwrappingSerializer(NameTransformer nameTransformer) {
        NameTransformer nameTransformer2;
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer != null && (jsonSerializer = jsonSerializer.unwrappingSerializer(nameTransformer)) == this._valueSerializer) {
            return this;
        }
        NameTransformer nameTransformer3 = nameTransformer2 = this._unwrapper == null ? nameTransformer : NameTransformer.chainedTransformer(nameTransformer, this._unwrapper);
        if (this._valueSerializer == jsonSerializer && this._unwrapper == nameTransformer2) {
            return this;
        }
        return this.withResolved(this._property, this._valueTypeSerializer, jsonSerializer, nameTransformer2);
    }

    protected abstract ReferenceTypeSerializer<T> withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer<?> var3, NameTransformer var4);

    public abstract ReferenceTypeSerializer<T> withContentInclusion(Object var1, boolean var2);

    protected abstract boolean _isValuePresent(T var1);

    protected abstract Object _getReferenced(T var1);

    protected abstract Object _getReferencedIfPresent(T var1);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonInclude.Include include;
        JsonInclude.Value value;
        JsonSerializer<Object> jsonSerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        if ((jsonSerializer = this.findAnnotatedContentSerializer(serializerProvider, beanProperty)) == null) {
            jsonSerializer = this._valueSerializer;
            if (jsonSerializer == null) {
                if (this._useStatic(serializerProvider, beanProperty, this._referredType)) {
                    jsonSerializer = this._findSerializer(serializerProvider, this._referredType, beanProperty);
                }
            } else {
                jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, beanProperty);
            }
        }
        ReferenceTypeSerializer<T> referenceTypeSerializer = this._property == beanProperty && this._valueTypeSerializer == typeSerializer && this._valueSerializer == jsonSerializer ? this : this.withResolved(beanProperty, typeSerializer, jsonSerializer, this._unwrapper);
        if (beanProperty != null && (value = beanProperty.findPropertyInclusion(serializerProvider.getConfig(), this.handledType())) != null && (include = value.getContentInclusion()) != JsonInclude.Include.USE_DEFAULTS) {
            boolean bl2;
            Object object;
            switch (include) {
                case NON_DEFAULT: {
                    object = BeanUtil.getDefaultValue(this._referredType);
                    bl2 = true;
                    if (object == null || !object.getClass().isArray()) break;
                    object = ArrayBuilders.getArrayComparator(object);
                    break;
                }
                case NON_ABSENT: {
                    bl2 = true;
                    object = this._referredType.isReferenceType() ? MARKER_FOR_EMPTY : null;
                    break;
                }
                case NON_EMPTY: {
                    bl2 = true;
                    object = MARKER_FOR_EMPTY;
                    break;
                }
                case CUSTOM: {
                    object = serializerProvider.includeFilterInstance(null, value.getContentFilter());
                    if (object == null) {
                        bl2 = true;
                        break;
                    }
                    bl2 = serializerProvider.includeFilterSuppressNulls(object);
                    break;
                }
                case NON_NULL: {
                    object = null;
                    bl2 = true;
                    break;
                }
                default: {
                    object = null;
                    bl2 = false;
                }
            }
            if (this._suppressableValue != object || this._suppressNulls != bl2) {
                referenceTypeSerializer = referenceTypeSerializer.withContentInclusion(object, bl2);
            }
        }
        return referenceTypeSerializer;
    }

    protected boolean _useStatic(SerializerProvider serializerProvider, BeanProperty beanProperty, JavaType javaType) {
        AnnotatedMember annotatedMember;
        if (javaType.isJavaLangObject()) {
            return false;
        }
        if (javaType.isFinal()) {
            return true;
        }
        if (javaType.useStaticType()) {
            return true;
        }
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && beanProperty != null && (annotatedMember = beanProperty.getMember()) != null) {
            JsonSerialize.Typing typing = annotationIntrospector.findSerializationTyping(beanProperty.getMember());
            if (typing == JsonSerialize.Typing.STATIC) {
                return true;
            }
            if (typing == JsonSerialize.Typing.DYNAMIC) {
                return false;
            }
        }
        return serializerProvider.isEnabled(MapperFeature.USE_STATIC_TYPING);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t2) {
        if (!this._isValuePresent(t2)) {
            return true;
        }
        Object object = this._getReferenced(t2);
        if (object == null) {
            return this._suppressNulls;
        }
        if (this._suppressableValue == null) {
            return false;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            try {
                jsonSerializer = this._findCachedSerializer(serializerProvider, object.getClass());
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
        }
        if (this._suppressableValue == MARKER_FOR_EMPTY) {
            return jsonSerializer.isEmpty(serializerProvider, object);
        }
        return this._suppressableValue.equals(object);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return this._unwrapper != null;
    }

    @Override
    public void serialize(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object object = this._getReferencedIfPresent(t2);
        if (object == null) {
            if (this._unwrapper == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findCachedSerializer(serializerProvider, object.getClass());
        }
        if (this._valueTypeSerializer != null) {
            jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, this._valueTypeSerializer);
        } else {
            jsonSerializer.serialize(object, jsonGenerator, serializerProvider);
        }
    }

    @Override
    public void serializeWithType(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        Object object = this._getReferencedIfPresent(t2);
        if (object == null) {
            if (this._unwrapper == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findCachedSerializer(serializerProvider, object.getClass());
        }
        jsonSerializer.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findSerializer(jsonFormatVisitorWrapper.getProvider(), this._referredType, this._property);
            if (this._unwrapper != null) {
                jsonSerializer = jsonSerializer.unwrappingSerializer(this._unwrapper);
            }
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, this._referredType);
    }

    private final JsonSerializer<Object> _findCachedSerializer(SerializerProvider serializerProvider, Class<?> clazz) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(clazz);
        if (jsonSerializer == null) {
            if (this._referredType.hasGenericTypes()) {
                JavaType javaType = serializerProvider.constructSpecializedType(this._referredType, clazz);
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(javaType, this._property);
            } else {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(clazz, this._property);
            }
            if (this._unwrapper != null) {
                jsonSerializer = jsonSerializer.unwrappingSerializer(this._unwrapper);
            }
            this._dynamicSerializers = this._dynamicSerializers.newWith(clazz, jsonSerializer);
        }
        return jsonSerializer;
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider serializerProvider, JavaType javaType, BeanProperty beanProperty) throws JsonMappingException {
        return serializerProvider.findPrimaryPropertySerializer(javaType, beanProperty);
    }
}

