/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CollectPreconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.CompactHashing;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Hashing;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ObjectArrays;
import com.gradle.maven.extension.internal.dep.com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private transient Object table;
    private transient int[] entries;
    transient Object[] elements;
    private transient int metadata;
    private transient int size;

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    CompactHashSet() {
        this.init(3);
    }

    void init(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Expected size must be >= 0");
        this.metadata = Ints.constrainToRange(n2, 1, 0x3FFFFFFF);
    }

    boolean needsAllocArrays() {
        return this.table == null;
    }

    int allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int n2 = this.metadata;
        int n3 = CompactHashing.tableSize(n2);
        this.table = CompactHashing.createTable(n3);
        this.setHashTableMask(n3 - 1);
        this.entries = new int[n2];
        this.elements = new Object[n2];
        return n2;
    }

    Set<E> delegateOrNull() {
        if (this.table instanceof Set) {
            return (Set)this.table;
        }
        return null;
    }

    private Set<E> createHashFloodingResistantDelegate(int n2) {
        return new LinkedHashSet(n2, 1.0f);
    }

    Set<E> convertToHashFloodingResistantImplementation() {
        Set<E> set = this.createHashFloodingResistantDelegate(this.hashTableMask() + 1);
        int n2 = this.firstEntryIndex();
        while (n2 >= 0) {
            set.add(this.element(n2));
            n2 = this.getSuccessor(n2);
        }
        this.table = set;
        this.entries = null;
        this.elements = null;
        this.incrementModCount();
        return set;
    }

    private void setHashTableMask(int n2) {
        int n3 = 32 - Integer.numberOfLeadingZeros(n2);
        this.metadata = CompactHashing.maskCombine(this.metadata, n3, 31);
    }

    private int hashTableMask() {
        return (1 << (this.metadata & 0x1F)) - 1;
    }

    void incrementModCount() {
        this.metadata += 32;
    }

    @Override
    public boolean add(E e2) {
        Set<E> set;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        if ((set = this.delegateOrNull()) != null) {
            return set.add(e2);
        }
        int[] nArray = this.requireEntries();
        Object[] objectArray = this.requireElements();
        int n2 = this.size;
        int n3 = n2 + 1;
        int n4 = Hashing.smearedHash(e2);
        int n5 = this.hashTableMask();
        int n6 = n4 & n5;
        int n7 = CompactHashing.tableGet(this.requireTable(), n6);
        if (n7 == 0) {
            if (n3 > n5) {
                n5 = this.resizeTable(n5, CompactHashing.newCapacity(n5), n4, n2);
            } else {
                CompactHashing.tableSet(this.requireTable(), n6, n2 + 1);
            }
        } else {
            int n8;
            int n9 = CompactHashing.getHashPrefix(n4, n5);
            int n10 = 0;
            do {
                int n11;
                if (CompactHashing.getHashPrefix(n8 = nArray[n11 = n7 - 1], n5) == n9 && Objects.equal(e2, objectArray[n11])) {
                    return false;
                }
                n7 = CompactHashing.getNext(n8, n5);
                ++n10;
            } while (n7 != 0);
            if (n10 >= 9) {
                return this.convertToHashFloodingResistantImplementation().add(e2);
            }
            if (n3 > n5) {
                n5 = this.resizeTable(n5, CompactHashing.newCapacity(n5), n4, n2);
            } else {
                nArray[n11] = CompactHashing.maskCombine(n8, n2 + 1, n5);
            }
        }
        this.resizeMeMaybe(n3);
        this.insertEntry(n2, e2, n4, n5);
        this.size = n3;
        this.incrementModCount();
        return true;
    }

    void insertEntry(int n2, E e2, int n3, int n4) {
        this.setEntry(n2, CompactHashing.maskCombine(n3, 0, n4));
        this.setElement(n2, e2);
    }

    private void resizeMeMaybe(int n2) {
        int n3;
        int n4 = this.requireEntries().length;
        if (n2 > n4 && (n3 = Math.min(0x3FFFFFFF, n4 + Math.max(1, n4 >>> 1) | 1)) != n4) {
            this.resizeEntries(n3);
        }
    }

    void resizeEntries(int n2) {
        this.entries = Arrays.copyOf(this.requireEntries(), n2);
        this.elements = Arrays.copyOf(this.requireElements(), n2);
    }

    private int resizeTable(int n2, int n3, int n4, int n5) {
        Object object = CompactHashing.createTable(n3);
        int n6 = n3 - 1;
        if (n5 != 0) {
            CompactHashing.tableSet(object, n4 & n6, n5 + 1);
        }
        Object object2 = this.requireTable();
        int[] nArray = this.requireEntries();
        for (int i2 = 0; i2 <= n2; ++i2) {
            int n7 = CompactHashing.tableGet(object2, i2);
            while (n7 != 0) {
                int n8 = n7 - 1;
                int n9 = nArray[n8];
                int n10 = CompactHashing.getHashPrefix(n9, n2) | i2;
                int n11 = n10 & n6;
                int n12 = CompactHashing.tableGet(object, n11);
                CompactHashing.tableSet(object, n11, n7);
                nArray[n8] = CompactHashing.maskCombine(n10, n12, n6);
                n7 = CompactHashing.getNext(n9, n2);
            }
        }
        this.table = object;
        this.setHashTableMask(n6);
        return n6;
    }

    @Override
    public boolean contains(Object object) {
        int n2;
        if (this.needsAllocArrays()) {
            return false;
        }
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            return set.contains(object);
        }
        int n3 = Hashing.smearedHash(object);
        int n4 = this.hashTableMask();
        int n5 = CompactHashing.tableGet(this.requireTable(), n3 & n4);
        if (n5 == 0) {
            return false;
        }
        int n6 = CompactHashing.getHashPrefix(n3, n4);
        do {
            int n7;
            if (CompactHashing.getHashPrefix(n2 = this.entry(n7 = n5 - 1), n4) != n6 || !Objects.equal(object, this.element(n7))) continue;
            return true;
        } while ((n5 = CompactHashing.getNext(n2, n4)) != 0);
        return false;
    }

    @Override
    public boolean remove(Object object) {
        if (this.needsAllocArrays()) {
            return false;
        }
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            return set.remove(object);
        }
        int n2 = this.hashTableMask();
        int n3 = CompactHashing.remove(object, null, n2, this.requireTable(), this.requireEntries(), this.requireElements(), null);
        if (n3 == -1) {
            return false;
        }
        this.moveLastEntry(n3, n2);
        --this.size;
        this.incrementModCount();
        return true;
    }

    void moveLastEntry(int n2, int n3) {
        Object object = this.requireTable();
        int[] nArray = this.requireEntries();
        Object[] objectArray = this.requireElements();
        int n4 = this.size() - 1;
        if (n2 < n4) {
            int n5;
            Object object2;
            objectArray[n2] = object2 = objectArray[n4];
            objectArray[n4] = null;
            nArray[n2] = nArray[n4];
            nArray[n4] = 0;
            int n6 = Hashing.smearedHash(object2) & n3;
            int n7 = CompactHashing.tableGet(object, n6);
            if (n7 == (n5 = n4 + 1)) {
                CompactHashing.tableSet(object, n6, n2 + 1);
            } else {
                int n8;
                int n9;
                while ((n7 = CompactHashing.getNext(n9 = nArray[n8 = n7 - 1], n3)) != n5) {
                }
                nArray[n8] = CompactHashing.maskCombine(n9, n2 + 1, n3);
            }
        } else {
            objectArray[n2] = null;
            nArray[n2] = 0;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int n2) {
        return n2 + 1 < this.size ? n2 + 1 : -1;
    }

    int adjustAfterRemove(int n2, int n3) {
        return n2 - 1;
    }

    @Override
    public Iterator<E> iterator() {
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            return set.iterator();
        }
        return new Iterator<E>(){
            int expectedMetadata;
            int currentIndex;
            int indexToRemove;
            {
                this.expectedMetadata = CompactHashSet.this.metadata;
                this.currentIndex = CompactHashSet.this.firstEntryIndex();
                this.indexToRemove = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex >= 0;
            }

            @Override
            public E next() {
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.indexToRemove = this.currentIndex;
                Object object = CompactHashSet.this.element(this.currentIndex);
                this.currentIndex = CompactHashSet.this.getSuccessor(this.currentIndex);
                return object;
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                CollectPreconditions.checkRemove(this.indexToRemove >= 0);
                this.incrementExpectedModCount();
                CompactHashSet.this.remove(CompactHashSet.this.element(this.indexToRemove));
                this.currentIndex = CompactHashSet.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
                this.indexToRemove = -1;
            }

            void incrementExpectedModCount() {
                this.expectedMetadata += 32;
            }

            private void checkForConcurrentModification() {
                if (CompactHashSet.this.metadata != this.expectedMetadata) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.needsAllocArrays()) {
            return Spliterators.spliterator(new Object[0], 17);
        }
        Set<E> set = this.delegateOrNull();
        return set != null ? set.spliterator() : Spliterators.spliterator(this.requireElements(), 0, this.size, 17);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            set.forEach(consumer);
        } else {
            int n2 = this.firstEntryIndex();
            while (n2 >= 0) {
                consumer.accept(this.element(n2));
                n2 = this.getSuccessor(n2);
            }
        }
    }

    @Override
    public int size() {
        Set<E> set = this.delegateOrNull();
        return set != null ? set.size() : this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray() {
        if (this.needsAllocArrays()) {
            return new Object[0];
        }
        Set<E> set = this.delegateOrNull();
        return set != null ? set.toArray() : Arrays.copyOf(this.requireElements(), this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (this.needsAllocArrays()) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }
        Set<E> set = this.delegateOrNull();
        return set != null ? set.toArray(TArray) : ObjectArrays.toArrayImpl(this.requireElements(), 0, this.size, TArray);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.incrementModCount();
        Set<E> set = this.delegateOrNull();
        if (set != null) {
            this.metadata = Ints.constrainToRange(this.size(), 3, 0x3FFFFFFF);
            set.clear();
            this.table = null;
            this.size = 0;
        } else {
            Arrays.fill(this.requireElements(), 0, this.size, null);
            CompactHashing.tableClear(this.requireTable());
            Arrays.fill(this.requireEntries(), 0, this.size, 0);
            this.size = 0;
        }
    }

    private Object requireTable() {
        return java.util.Objects.requireNonNull(this.table);
    }

    private int[] requireEntries() {
        return java.util.Objects.requireNonNull(this.entries);
    }

    private Object[] requireElements() {
        return java.util.Objects.requireNonNull(this.elements);
    }

    private E element(int n2) {
        return (E)this.requireElements()[n2];
    }

    private int entry(int n2) {
        return this.requireEntries()[n2];
    }

    private void setElement(int n2, E e2) {
        this.requireElements()[n2] = e2;
    }

    private void setEntry(int n2, int n3) {
        this.requireEntries()[n2] = n3;
    }
}

