/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Objects;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Hashing;
import java.util.Arrays;

final class CompactHashing {
    static int tableSize(int n2) {
        return Math.max(4, Hashing.closedTableSize(n2 + 1, 1.0));
    }

    static Object createTable(int n2) {
        if (n2 < 2 || n2 > 0x40000000 || Integer.highestOneBit(n2) != n2) {
            throw new IllegalArgumentException("must be power of 2 between 2^1 and 2^30: " + n2);
        }
        if (n2 <= 256) {
            return new byte[n2];
        }
        if (n2 <= 65536) {
            return new short[n2];
        }
        return new int[n2];
    }

    static void tableClear(Object object) {
        if (object instanceof byte[]) {
            Arrays.fill((byte[])object, (byte)0);
        } else if (object instanceof short[]) {
            Arrays.fill((short[])object, (short)0);
        } else {
            Arrays.fill((int[])object, 0);
        }
    }

    static int tableGet(Object object, int n2) {
        if (object instanceof byte[]) {
            return ((byte[])object)[n2] & 0xFF;
        }
        if (object instanceof short[]) {
            return ((short[])object)[n2] & 0xFFFF;
        }
        return ((int[])object)[n2];
    }

    static void tableSet(Object object, int n2, int n3) {
        if (object instanceof byte[]) {
            ((byte[])object)[n2] = (byte)n3;
        } else if (object instanceof short[]) {
            ((short[])object)[n2] = (short)n3;
        } else {
            ((int[])object)[n2] = n3;
        }
    }

    static int newCapacity(int n2) {
        return (n2 < 32 ? 4 : 2) * (n2 + 1);
    }

    static int getHashPrefix(int n2, int n3) {
        return n2 & ~n3;
    }

    static int getNext(int n2, int n3) {
        return n2 & n3;
    }

    static int maskCombine(int n2, int n3, int n4) {
        return n2 & ~n4 | n3 & n4;
    }

    static int remove(Object object, Object object2, int n2, Object object3, int[] nArray, Object[] objectArray, Object[] objectArray2) {
        int n3;
        int n4 = Hashing.smearedHash(object);
        int n5 = n4 & n2;
        int n6 = CompactHashing.tableGet(object3, n5);
        if (n6 == 0) {
            return -1;
        }
        int n7 = CompactHashing.getHashPrefix(n4, n2);
        int n8 = -1;
        do {
            int n9;
            if (CompactHashing.getHashPrefix(n3 = nArray[n9 = n6 - 1], n2) == n7 && Objects.equal(object, objectArray[n9]) && (objectArray2 == null || Objects.equal(object2, objectArray2[n9]))) {
                int n10 = CompactHashing.getNext(n3, n2);
                if (n8 == -1) {
                    CompactHashing.tableSet(object3, n5, n10);
                } else {
                    nArray[n8] = CompactHashing.maskCombine(nArray[n8], n10, n2);
                }
                return n9;
            }
            n8 = n9;
        } while ((n6 = CompactHashing.getNext(n3, n2)) != 0);
        return -1;
    }
}

