/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Function;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ByFunctionOrdering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ComparatorOrdering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ExplicitOrdering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.LexicographicalOrdering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.MapMaker;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Maps;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.NaturalOrdering;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Platform;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ReverseOrdering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    public static <T> Ordering<T> explicit(List<T> list) {
        return new ExplicitOrdering<T>(list);
    }

    public static <T> Ordering<T> explicit(T t2, T ... TArray) {
        return Ordering.explicit(Lists.asList(t2, TArray));
    }

    public static Ordering<Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @Override
    public abstract int compare(T var1, T var2);

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> iterable) {
        return ImmutableList.sortedCopyOf(this, iterable);
    }

    static class IncomparableValueException
    extends ClassCastException {
        final Object value;

        IncomparableValueException(Object object) {
            super("Cannot compare value: " + object);
            this.value = object;
        }
    }

    static class ArbitraryOrdering
    extends Ordering<Object> {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final ConcurrentMap<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeMap();

        ArbitraryOrdering() {
        }

        private Integer getUid(Object object) {
            Integer n2;
            Integer n3 = (Integer)this.uids.get(object);
            if (n3 == null && (n2 = this.uids.putIfAbsent(object, n3 = Integer.valueOf(this.counter.getAndIncrement()))) != null) {
                n3 = n2;
            }
            return n3;
        }

        @Override
        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            int n3 = this.identityHashCode(object);
            if (n3 != (n2 = this.identityHashCode(object2))) {
                return n3 < n2 ? -1 : 1;
            }
            int n4 = this.getUid(object).compareTo(this.getUid(object2));
            if (n4 == 0) {
                throw new AssertionError();
            }
            return n4;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<Object> ARBITRARY_ORDERING = new ArbitraryOrdering();
    }
}

