/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression;

import com.gradle.maven.extension.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.maven.extension.internal.dep.io.netty.handler.codec.compression.CompressionUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.ByteProcessor;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.maven.extension.internal.dep.io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

abstract class ByteBufChecksum
implements Checksum {
    private final ByteProcessor updateProcessor = new ByteProcessor(){

        @Override
        public boolean process(byte by2) throws Exception {
            ByteBufChecksum.this.update(by2);
            return true;
        }
    };

    ByteBufChecksum() {
    }

    private static Method updateByteBuffer(Checksum checksum) {
        if (PlatformDependent.javaVersion() >= 8) {
            try {
                Method method = checksum.getClass().getDeclaredMethod("update", ByteBuffer.class);
                method.invoke((Object)checksum, ByteBuffer.allocate(1));
                return method;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        ObjectUtil.checkNotNull(checksum, "checksum");
        if (checksum instanceof ByteBufChecksum) {
            return (ByteBufChecksum)checksum;
        }
        if (checksum instanceof Adler32 && ZlibChecksumMethods.ADLER32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.ADLER32_UPDATE_METHOD);
        }
        if (checksum instanceof CRC32 && ZlibChecksumMethods.CRC32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.CRC32_UPDATE_METHOD);
        }
        return new SlowByteBufChecksum(checksum);
    }

    public void update(ByteBuf byteBuf, int n2, int n3) {
        if (byteBuf.hasArray()) {
            this.update(byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
        } else {
            byteBuf.forEachByte(n2, n3, this.updateProcessor);
        }
    }

    static /* synthetic */ Method access$000(Checksum checksum) {
        return ByteBufChecksum.updateByteBuffer(checksum);
    }

    private static class SlowByteBufChecksum
    extends ByteBufChecksum {
        protected final Checksum checksum;

        SlowByteBufChecksum(Checksum checksum) {
            this.checksum = checksum;
        }

        @Override
        public void update(int n2) {
            this.checksum.update(n2);
        }

        @Override
        public void update(byte[] byArray, int n2, int n3) {
            this.checksum.update(byArray, n2, n3);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }

    private static final class ReflectiveByteBufChecksum
    extends SlowByteBufChecksum {
        private final Method method;

        ReflectiveByteBufChecksum(Checksum checksum, Method method) {
            super(checksum);
            this.method = method;
        }

        @Override
        public void update(ByteBuf byteBuf, int n2, int n3) {
            if (byteBuf.hasArray()) {
                this.update(byteBuf.array(), byteBuf.arrayOffset() + n2, n3);
            } else {
                try {
                    this.method.invoke((Object)this.checksum, CompressionUtil.safeNioBuffer(byteBuf, n2, n3));
                }
                catch (Throwable throwable) {
                    throw new Error();
                }
            }
        }
    }

    private static class ZlibChecksumMethods {
        private static final Method ADLER32_UPDATE_METHOD = ByteBufChecksum.access$000(new Adler32());
        private static final Method CRC32_UPDATE_METHOD = ByteBufChecksum.access$000(new CRC32());
    }
}

