/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard;

import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.standard.TokenKind;

class Token {
    TokenKind kind;
    String data;
    int startPos;
    int endPos;

    Token(TokenKind tokenKind, int n2, int n3) {
        this.kind = tokenKind;
        this.startPos = n2;
        this.endPos = n3;
    }

    Token(TokenKind tokenKind, char[] cArray, int n2, int n3) {
        this(tokenKind, n2, n3);
        this.data = new String(cArray);
    }

    public TokenKind getKind() {
        return this.kind;
    }

    public boolean isIdentifier() {
        return this.kind == TokenKind.IDENTIFIER;
    }

    public boolean isNumericRelationalOperator() {
        return this.kind == TokenKind.GT || this.kind == TokenKind.GE || this.kind == TokenKind.LT || this.kind == TokenKind.LE || this.kind == TokenKind.EQ || this.kind == TokenKind.NE;
    }

    public String stringValue() {
        return this.data != null ? this.data : "";
    }

    public Token asInstanceOfToken() {
        return new Token(TokenKind.INSTANCEOF, this.startPos, this.endPos);
    }

    public Token asMatchesToken() {
        return new Token(TokenKind.MATCHES, this.startPos, this.endPos);
    }

    public Token asBetweenToken() {
        return new Token(TokenKind.BETWEEN, this.startPos, this.endPos);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append((Object)this.kind);
        if (this.kind.hasPayload()) {
            stringBuilder.append(':').append(this.data);
        }
        stringBuilder.append(']');
        stringBuilder.append('(').append(this.startPos).append(',').append(this.endPos).append(')');
        return stringBuilder.toString();
    }
}

