/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.MethodParameter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.AccessException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ConstructorExecutor;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.ConstructorResolver;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationContext;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.EvaluationException;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.TypeConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectionHelper;
import com.gradle.maven.extension.internal.dep.org.springframework.expression.spel.support.ReflectiveConstructorExecutor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ReflectiveConstructorResolver
implements ConstructorResolver {
    @Override
    public ConstructorExecutor resolve(EvaluationContext evaluationContext, String string, List<TypeDescriptor> list) throws AccessException {
        try {
            TypeConverter typeConverter = evaluationContext.getTypeConverter();
            Class<?> clazz = evaluationContext.getTypeLocator().findType(string);
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Arrays.sort(constructorArray, Comparator.comparingInt(Constructor::getParameterCount));
            Constructor<?> constructor = null;
            Constructor<?> constructor2 = null;
            for (Constructor<?> constructor3 : constructorArray) {
                int n2 = constructor3.getParameterCount();
                ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    arrayList.add(new TypeDescriptor(new MethodParameter(constructor3, i2)));
                }
                ReflectionHelper.ArgumentsMatchInfo argumentsMatchInfo = null;
                if (constructor3.isVarArgs() && list.size() >= n2 - 1) {
                    argumentsMatchInfo = ReflectionHelper.compareArgumentsVarargs(arrayList, list, typeConverter);
                } else if (n2 == list.size()) {
                    argumentsMatchInfo = ReflectionHelper.compareArguments(arrayList, list, typeConverter);
                }
                if (argumentsMatchInfo == null) continue;
                if (argumentsMatchInfo.isExactMatch()) {
                    return new ReflectiveConstructorExecutor(constructor3);
                }
                if (argumentsMatchInfo.isCloseMatch()) {
                    constructor = constructor3;
                    continue;
                }
                if (!argumentsMatchInfo.isMatchRequiringConversion()) continue;
                constructor2 = constructor3;
            }
            if (constructor != null) {
                return new ReflectiveConstructorExecutor(constructor);
            }
            if (constructor2 != null) {
                return new ReflectiveConstructorExecutor(constructor2);
            }
            return null;
        }
        catch (EvaluationException evaluationException) {
            throw new AccessException("Failed to resolve constructor", evaluationException);
        }
    }
}

